@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightStreamingActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.HDInsightActivityDebugInfoOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight streaming activity type.
 * @property arguments User specified arguments to HDInsightActivity.
 * @property combiner Combiner executable name. Type: string (or Expression with resultType string).
 * @property commandEnvironment Command line environment values.
 * @property defines Allows user to specify defines for streaming job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property fileLinkedService Linked service reference where the files are located.
 * @property filePaths Paths to streaming job files. Can be directories.
 * @property getDebugInfo Debug info option.
 * @property input Input blob path. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property mapper Mapper executable name. Type: string (or Expression with resultType string).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property output Output blob path. Type: string (or Expression with resultType string).
 * @property policy Activity policy.
 * @property reducer Reducer executable name. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightStreaming'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightStreamingActivityArgs(
    public val arguments: Output<List<Any>>? = null,
    public val combiner: Output<Any>? = null,
    public val commandEnvironment: Output<List<Any>>? = null,
    public val defines: Output<Map<String, Any>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val fileLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val filePaths: Output<List<Any>>,
    public val getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null,
    public val input: Output<Any>,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val mapper: Output<Any>,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val output: Output<Any>,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val reducer: Output<Any>,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightStreamingActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightStreamingActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightStreamingActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .combiner(combiner?.applyValue({ args0 -> args0 }))
            .commandEnvironment(commandEnvironment?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defines(defines?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .fileLinkedService(fileLinkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filePaths(filePaths.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .getDebugInfo(
                getDebugInfo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .input(input.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mapper(mapper.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .output(output.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reducer(reducer.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageLinkedServices(
                storageLinkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HDInsightStreamingActivityArgs].
 */
@PulumiTagMarker
public class HDInsightStreamingActivityArgsBuilder internal constructor() {
    private var arguments: Output<List<Any>>? = null

    private var combiner: Output<Any>? = null

    private var commandEnvironment: Output<List<Any>>? = null

    private var defines: Output<Map<String, Any>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var fileLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var filePaths: Output<List<Any>>? = null

    private var getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null

    private var input: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var mapper: Output<Any>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var output: Output<Any>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var reducer: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("okqngakatbjlctdc")
    public suspend fun arguments(`value`: Output<List<Any>>) {
        this.arguments = value
    }

    @JvmName("jukwrpavwxtuopmf")
    public suspend fun arguments(vararg values: Output<Any>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("tqnrbohtdxxctkyu")
    public suspend fun arguments(values: List<Output<Any>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value Combiner executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("sseoqngxljdgvsqm")
    public suspend fun combiner(`value`: Output<Any>) {
        this.combiner = value
    }

    /**
     * @param value Command line environment values.
     */
    @JvmName("lbmkibrudykswgdc")
    public suspend fun commandEnvironment(`value`: Output<List<Any>>) {
        this.commandEnvironment = value
    }

    @JvmName("ghxaqqmnhxbnyilg")
    public suspend fun commandEnvironment(vararg values: Output<Any>) {
        this.commandEnvironment = Output.all(values.asList())
    }

    /**
     * @param values Command line environment values.
     */
    @JvmName("tofklbmeelgigxxq")
    public suspend fun commandEnvironment(values: List<Output<Any>>) {
        this.commandEnvironment = Output.all(values)
    }

    /**
     * @param value Allows user to specify defines for streaming job request.
     */
    @JvmName("kcmbainfdgiobrcy")
    public suspend fun defines(`value`: Output<Map<String, Any>>) {
        this.defines = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("fkedvjfpubvmnkqm")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("iorubybldkirgakr")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("evqwmxoekuvrxtpw")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("peukilaemolagnir")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Linked service reference where the files are located.
     */
    @JvmName("owsglajsbbwwbrhn")
    public suspend fun fileLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.fileLinkedService = value
    }

    /**
     * @param value Paths to streaming job files. Can be directories.
     */
    @JvmName("skkuhyeqrhfjqxru")
    public suspend fun filePaths(`value`: Output<List<Any>>) {
        this.filePaths = value
    }

    @JvmName("hhvmwlpvrqvkrbpg")
    public suspend fun filePaths(vararg values: Output<Any>) {
        this.filePaths = Output.all(values.asList())
    }

    /**
     * @param values Paths to streaming job files. Can be directories.
     */
    @JvmName("hxwvpimwmguefhtp")
    public suspend fun filePaths(values: List<Output<Any>>) {
        this.filePaths = Output.all(values)
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("ljlqbpbovoqkwvmr")
    public suspend fun getDebugInfo(`value`: Output<Either<String, HDInsightActivityDebugInfoOption>>) {
        this.getDebugInfo = value
    }

    /**
     * @param value Input blob path. Type: string (or Expression with resultType string).
     */
    @JvmName("qkkdmoegbbuhrdkq")
    public suspend fun input(`value`: Output<Any>) {
        this.input = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("ooomqdkhegfgqmnx")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Mapper executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("hxtewojklmcclwkr")
    public suspend fun mapper(`value`: Output<Any>) {
        this.mapper = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("qbaxhhakcluokmqs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("qlvyniptmxwfhycw")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Output blob path. Type: string (or Expression with resultType string).
     */
    @JvmName("qfiqhpbqgleafiwg")
    public suspend fun output(`value`: Output<Any>) {
        this.output = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("skwtiunmegjwpvor")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Reducer executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("mmdgwltnxewsodpb")
    public suspend fun reducer(`value`: Output<Any>) {
        this.reducer = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ojbnhytvsbvwrslc")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("wstepldrebpcghfv")
    public suspend fun storageLinkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = value
    }

    @JvmName("xuwvspkjajkvyven")
    public suspend fun storageLinkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.storageLinkedServices = Output.all(values.asList())
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("pafxesoftvnmevyr")
    public suspend fun storageLinkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = Output.all(values)
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightStreaming'.
     */
    @JvmName("xdcrvcycnwhjnmjs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("lnqnydfvrvouddqr")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("pxtwfpjqermsypea")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("visewkhqlxqqekmt")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("jjrgfcqxbbphliwx")
    public suspend fun arguments(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("csqldyxcytwvxclb")
    public suspend fun arguments(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Combiner executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("wyatfvewgpvsnlbh")
    public suspend fun combiner(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.combiner = mapped
    }

    /**
     * @param value Command line environment values.
     */
    @JvmName("fibgwncplldyniia")
    public suspend fun commandEnvironment(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandEnvironment = mapped
    }

    /**
     * @param values Command line environment values.
     */
    @JvmName("iueggnaarftoibfc")
    public suspend fun commandEnvironment(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandEnvironment = mapped
    }

    /**
     * @param value Allows user to specify defines for streaming job request.
     */
    @JvmName("rntvicxsxjbgijpm")
    public suspend fun defines(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param values Allows user to specify defines for streaming job request.
     */
    @JvmName("biqvbqvvwkmtjdmr")
    public fun defines(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("foyxnsmaxtbadmtf")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("adjeptsrufxwqgyr")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("valggpawfxyrmhin")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("fmktstorqiftyujq")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("yglvcxhdwkdcwmpu")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("oreegmsphweuichr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Linked service reference where the files are located.
     */
    @JvmName("vtavrophkbvlqqpb")
    public suspend fun fileLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileLinkedService = mapped
    }

    /**
     * @param argument Linked service reference where the files are located.
     */
    @JvmName("adiggkoogckjewwx")
    public suspend fun fileLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileLinkedService = mapped
    }

    /**
     * @param value Paths to streaming job files. Can be directories.
     */
    @JvmName("icdpfxnuffxlrlmk")
    public suspend fun filePaths(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param values Paths to streaming job files. Can be directories.
     */
    @JvmName("ddffxaiwidbmumhq")
    public suspend fun filePaths(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("hcpovdppskoventb")
    public suspend fun getDebugInfo(`value`: Either<String, HDInsightActivityDebugInfoOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("frqamhnbmwhjdppq")
    public fun getDebugInfo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("cjsqfmmyvopndsss")
    public fun getDebugInfo(`value`: HDInsightActivityDebugInfoOption) {
        val toBeMapped = Either.ofRight<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Input blob path. Type: string (or Expression with resultType string).
     */
    @JvmName("tcpkkpjiulibitkr")
    public suspend fun input(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("gfnyscaterjwbrtj")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("mgllvughxvvlpock")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Mapper executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("mghairtrhqnrowcf")
    public suspend fun mapper(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapper = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("dshkfrgmslatajal")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("gnbajjlvqcbwgonf")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("irtotyrftpsicolw")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("jnlraicigjibsmii")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Output blob path. Type: string (or Expression with resultType string).
     */
    @JvmName("qwhhwcrmevtikhtd")
    public suspend fun output(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("srdwqaomftosucvx")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("ejdjhmikslifyfer")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Reducer executable name. Type: string (or Expression with resultType string).
     */
    @JvmName("himwrutrbafggicu")
    public suspend fun reducer(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reducer = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("iycmnahjbmkwovii")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("yedyxahyofvbkoee")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("bnpivvvylywmsqaj")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("stqewkrevbyvoxda")
    public suspend fun storageLinkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("naohpjbjtkcrjbws")
    public suspend fun storageLinkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("hgjqgeyjfgqqnuku")
    public suspend fun storageLinkedServices(vararg argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("skmiuesfcfklqjcd")
    public suspend fun storageLinkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("kqsaadlkemkvtskw")
    public suspend fun storageLinkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightStreaming'.
     */
    @JvmName("vxywdfffsiqwqjso")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("ntwomfagdktcciek")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("ddqbeynkparylwta")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("bjpuygndhsraapww")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("usxiuxvgsjpvbxvx")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("wxcbsyjgsieyamhs")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): HDInsightStreamingActivityArgs = HDInsightStreamingActivityArgs(
        arguments = arguments,
        combiner = combiner,
        commandEnvironment = commandEnvironment,
        defines = defines,
        dependsOn = dependsOn,
        description = description,
        fileLinkedService = fileLinkedService,
        filePaths = filePaths ?: throw PulumiNullFieldException("filePaths"),
        getDebugInfo = getDebugInfo,
        input = input ?: throw PulumiNullFieldException("input"),
        linkedServiceName = linkedServiceName,
        mapper = mapper ?: throw PulumiNullFieldException("mapper"),
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        output = output ?: throw PulumiNullFieldException("output"),
        policy = policy,
        reducer = reducer ?: throw PulumiNullFieldException("reducer"),
        state = state,
        storageLinkedServices = storageLinkedServices,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
