@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HttpLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.HttpAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for an HTTP source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authHeaders The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
 * @property authenticationType The authentication type to be used to connect to the HTTP server.
 * @property certThumbprint Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property embeddedCertData Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
 * @property enableServerCertificateValidation If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
 * @property type Type of linked service.
 * Expected value is 'HttpServer'.
 * @property url The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
 * @property userName User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
 */
public data class HttpLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authHeaders: Output<Any>? = null,
    public val authenticationType: Output<Either<String, HttpAuthenticationType>>? = null,
    public val certThumbprint: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val embeddedCertData: Output<Any>? = null,
    public val enableServerCertificateValidation: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HttpLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HttpLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.HttpLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authHeaders(authHeaders?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .certThumbprint(certThumbprint?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .embeddedCertData(embeddedCertData?.applyValue({ args0 -> args0 }))
            .enableServerCertificateValidation(
                enableServerCertificateValidation?.applyValue({ args0 ->
                    args0
                }),
            )
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpLinkedServiceArgs].
 */
@PulumiTagMarker
public class HttpLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authHeaders: Output<Any>? = null

    private var authenticationType: Output<Either<String, HttpAuthenticationType>>? = null

    private var certThumbprint: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var embeddedCertData: Output<Any>? = null

    private var enableServerCertificateValidation: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gkgyeibsrswhiovs")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("nhrapxxuvnmquada")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("bipvcisneuuneovl")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
     */
    @JvmName("vuyrrwegmuasoafr")
    public suspend fun authHeaders(`value`: Output<Any>) {
        this.authHeaders = value
    }

    /**
     * @param value The authentication type to be used to connect to the HTTP server.
     */
    @JvmName("qkfjiwceswtfnuli")
    public suspend fun authenticationType(`value`: Output<Either<String, HttpAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("eyreqkdkkcjvuwmq")
    public suspend fun certThumbprint(`value`: Output<Any>) {
        this.certThumbprint = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("whdphftrssdatebe")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wkasrqbyjcmjrhcx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("ljntqmiqvdpixjpf")
    public suspend fun embeddedCertData(`value`: Output<Any>) {
        this.embeddedCertData = value
    }

    /**
     * @param value If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ltcsqmmscnuplfyh")
    public suspend fun enableServerCertificateValidation(`value`: Output<Any>) {
        this.enableServerCertificateValidation = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("msvamxjgdrcelwba")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("babivucvpeiinqxe")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
     */
    @JvmName("rbcharckxaafsoll")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HttpServer'.
     */
    @JvmName("kstjiojmxcxhpray")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
     */
    @JvmName("mnhvcvxhchqdcxgb")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("lndapnoarxtskyhn")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("rqlkvknuhsnktgjg")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("yakuckperrfqrhgt")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
     */
    @JvmName("losfntlhhddigbly")
    public suspend fun authHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authHeaders = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the HTTP server.
     */
    @JvmName("dncbkigdpckibbkc")
    public suspend fun authenticationType(`value`: Either<String, HttpAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the HTTP server.
     */
    @JvmName("leniywpkkdeddfgg")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HttpAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the HTTP server.
     */
    @JvmName("texwmdpiwnjagujc")
    public fun authenticationType(`value`: HttpAuthenticationType) {
        val toBeMapped = Either.ofRight<String, HttpAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("rveiusejqiwpdkmd")
    public suspend fun certThumbprint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certThumbprint = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("yvxshloqxaqcukdf")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("oejcihhtyhkvdokp")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bacxamveuqanggoq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     */
    @JvmName("cbqhgxuaqkexafoc")
    public suspend fun embeddedCertData(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embeddedCertData = mapped
    }

    /**
     * @param value If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("iorptpnbwjjyrtwl")
    public suspend fun enableServerCertificateValidation(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableServerCertificateValidation = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dbrurvnfivjpyphi")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("lgsqnytnqnbpehwb")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("rdyvntqgbtfmafvv")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jnwhgrnlmenbjdof")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
     */
    @JvmName("ppnftkimfuinneph")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
     */
    @JvmName("bdjrffnbkatvccbx")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
     */
    @JvmName("ywkpqhsgtdffrjvu")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HttpServer'.
     */
    @JvmName("ctsceydfycjwuald")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
     */
    @JvmName("vtlwexwtamrapqrt")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("sdvsahqkpvcstghb")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): HttpLinkedServiceArgs = HttpLinkedServiceArgs(
        annotations = annotations,
        authHeaders = authHeaders,
        authenticationType = authenticationType,
        certThumbprint = certThumbprint,
        connectVia = connectVia,
        description = description,
        embeddedCertData = embeddedCertData,
        enableServerCertificateValidation = enableServerCertificateValidation,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userName = userName,
    )
}
