@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IfConditionActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property expression An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
 * @property ifFalseActivities List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
 * @property ifTrueActivities List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'IfCondition'.
 * @property userProperties Activity user properties.
 */
public data class IfConditionActivityArgs(
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val expression: Output<ExpressionArgs>,
    public val ifFalseActivities: Output<List<Any>>? = null,
    public val ifTrueActivities: Output<List<Any>>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IfConditionActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.IfConditionActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.IfConditionActivityArgs.builder()
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ifFalseActivities(ifFalseActivities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ifTrueActivities(ifTrueActivities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IfConditionActivityArgs].
 */
@PulumiTagMarker
public class IfConditionActivityArgsBuilder internal constructor() {
    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var expression: Output<ExpressionArgs>? = null

    private var ifFalseActivities: Output<List<Any>>? = null

    private var ifTrueActivities: Output<List<Any>>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("osqxghtmnjuucffo")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("bbphsyaiciilmiar")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("lbqmacksyihdfmuw")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("xtmvbckmephefdhd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
     */
    @JvmName("uvsnikknfvnfkjyf")
    public suspend fun expression(`value`: Output<ExpressionArgs>) {
        this.expression = value
    }

    /**
     * @param value List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("niiuwbiiodbankec")
    public suspend fun ifFalseActivities(`value`: Output<List<Any>>) {
        this.ifFalseActivities = value
    }

    @JvmName("xjkofxxuifhfjdgs")
    public suspend fun ifFalseActivities(vararg values: Output<Any>) {
        this.ifFalseActivities = Output.all(values.asList())
    }

    /**
     * @param values List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("ildyqummyawmqfmi")
    public suspend fun ifFalseActivities(values: List<Output<Any>>) {
        this.ifFalseActivities = Output.all(values)
    }

    /**
     * @param value List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("khugqaqvhfuoalxg")
    public suspend fun ifTrueActivities(`value`: Output<List<Any>>) {
        this.ifTrueActivities = value
    }

    @JvmName("wggingemfyaldslk")
    public suspend fun ifTrueActivities(vararg values: Output<Any>) {
        this.ifTrueActivities = Output.all(values.asList())
    }

    /**
     * @param values List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("aheosuskjxlgkwbq")
    public suspend fun ifTrueActivities(values: List<Output<Any>>) {
        this.ifTrueActivities = Output.all(values)
    }

    /**
     * @param value Activity name.
     */
    @JvmName("tnqoxfxncabgrotb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("abhxnileqkyftwpt")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ofbcdqtejrlrqpfh")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'IfCondition'.
     */
    @JvmName("ntxamnxduxxfmpcf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("tqiyafnstpqiwnpk")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("ixrncgnvbmoxhblv")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("dmahwsjjhhibutyl")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("chkxhlcnuuqkglih")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("miftcxnedfqqlexh")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("xwohxgaphetgsnlo")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("fpijdxixwqcevynf")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("krstdicscjtnignd")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("nxqqbywhqaocjxtp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
     */
    @JvmName("aqgfdenpyjpxwjct")
    public suspend fun expression(`value`: ExpressionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param argument An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
     */
    @JvmName("ompainfolrtqykud")
    public suspend fun expression(argument: suspend ExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expression = mapped
    }

    /**
     * @param value List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("nkubprfxdkqgefcu")
    public suspend fun ifFalseActivities(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ifFalseActivities = mapped
    }

    /**
     * @param values List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("qhcovmjsqrvetfqi")
    public suspend fun ifFalseActivities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ifFalseActivities = mapped
    }

    /**
     * @param value List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("bbalcwbinwykfhhx")
    public suspend fun ifTrueActivities(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ifTrueActivities = mapped
    }

    /**
     * @param values List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("uflvcshgcgfliuga")
    public suspend fun ifTrueActivities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ifTrueActivities = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("qoigyupclgexfjpb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("upkrncddlnuwbget")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("pvdskuemucxjembx")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("vdjgnphwqexlbmtf")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("khrbsxapcdfauidy")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ywpwpasmixhmlsed")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ncvhkihbqfjadvhl")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'IfCondition'.
     */
    @JvmName("eodjlkgtouilsbwv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("nuhogcioatynaijr")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("qmrxwjqbdjvrirte")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("goeljpfbhsuqfeds")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("dbpflductigriqnh")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("tmsruinnlulyxkkn")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): IfConditionActivityArgs = IfConditionActivityArgs(
        dependsOn = dependsOn,
        description = description,
        expression = expression ?: throw PulumiNullFieldException("expression"),
        ifFalseActivities = ifFalseActivities,
        ifTrueActivities = ifTrueActivities,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
