@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.JiraLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Jira Service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The IP address or host name of the Jira service. (e.g. jira.example.com)
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name that you provided in the username field.
 * @property port The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
 * @property type Type of linked service.
 * Expected value is 'Jira'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 * @property username The user name that you use to access Jira Service.
 */
public data class JiraLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
    public val useHostVerification: Output<Any>? = null,
    public val usePeerVerification: Output<Any>? = null,
    public val username: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.JiraLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.JiraLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.JiraLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 }))
            .useHostVerification(useHostVerification?.applyValue({ args0 -> args0 }))
            .usePeerVerification(usePeerVerification?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JiraLinkedServiceArgs].
 */
@PulumiTagMarker
public class JiraLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    private var useHostVerification: Output<Any>? = null

    private var usePeerVerification: Output<Any>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("hgpodeoalcrmepcv")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("wtbfsxsgwoghpaog")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("afxsvjlbmfhebvgg")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("fuynxdpdhrrcpbug")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("xomhdvshapjvtkal")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("kjdnrkxwhqtklopc")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The IP address or host name of the Jira service. (e.g. jira.example.com)
     */
    @JvmName("pwvrcrrustjegwjv")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("kfyfxxwwggoauous")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password corresponding to the user name that you provided in the username field.
     */
    @JvmName("fqlvsqviokisbwka")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
     */
    @JvmName("bjmbutkayovanupo")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Jira'.
     */
    @JvmName("mswehxlivsbahort")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("pmpdhjwyfnufxsea")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("dkoedjmslpwyuhgu")
    public suspend fun useHostVerification(`value`: Output<Any>) {
        this.useHostVerification = value
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("idnypwqleanulumc")
    public suspend fun usePeerVerification(`value`: Output<Any>) {
        this.usePeerVerification = value
    }

    /**
     * @param value The user name that you use to access Jira Service.
     */
    @JvmName("drcaxjripgsjbsqv")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("eutasnaiqurrgtva")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("tqdcqtggfmdcrlsf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wdybpoylmkitxpdi")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("hnuruarsjbaygsur")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("dngqmbpfnjieptbj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ulndcrydjkiqpxhm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The IP address or host name of the Jira service. (e.g. jira.example.com)
     */
    @JvmName("beoxcxqyyjyeetxl")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("yrthkbitrmdgurvi")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("nuyqwkickhxrhfdc")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("irynjtwyrmtwufoc")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the username field.
     */
    @JvmName("geyrdrqgoxhqxhlu")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the username field.
     */
    @JvmName("qhcfnfkdwgafjcds")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the username field.
     */
    @JvmName("cwvnxaraoahuthnw")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
     */
    @JvmName("wqutultwsbtxckyl")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Jira'.
     */
    @JvmName("hjkmmsekjfsmitev")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("mmwniemkgrpjuavc")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("cujinfgpauaspufp")
    public suspend fun useHostVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHostVerification = mapped
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("gjwefexrhqsnvhfq")
    public suspend fun usePeerVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePeerVerification = mapped
    }

    /**
     * @param value The user name that you use to access Jira Service.
     */
    @JvmName("fusdbjttxracdddt")
    public suspend fun username(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): JiraLinkedServiceArgs = JiraLinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        parameters = parameters,
        password = password,
        port = port,
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
        useHostVerification = useHostVerification,
        usePeerVerification = usePeerVerification,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
