@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.JsonReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Json read settings.
 * @property compressionProperties Compression settings.
 * @property type The read setting type.
 * Expected value is 'JsonReadSettings'.
 */
public data class JsonReadSettingsArgs(
    public val compressionProperties: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.JsonReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.JsonReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.JsonReadSettingsArgs.builder()
            .compressionProperties(compressionProperties?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonReadSettingsArgs].
 */
@PulumiTagMarker
public class JsonReadSettingsArgsBuilder internal constructor() {
    private var compressionProperties: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Compression settings.
     */
    @JvmName("llubhkcfngcxossh")
    public suspend fun compressionProperties(`value`: Output<Any>) {
        this.compressionProperties = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'JsonReadSettings'.
     */
    @JvmName("bancmstbhbnykrbl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Compression settings.
     */
    @JvmName("hnkcncggtggckyjd")
    public suspend fun compressionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionProperties = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'JsonReadSettings'.
     */
    @JvmName("poenxnadtsvgvaqe")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JsonReadSettingsArgs = JsonReadSettingsArgs(
        compressionProperties = compressionProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
