@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LakeHouseLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of Microsoft Fabric LakeHouse Files dataset.
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'LakeHouseLocation'.
 */
public data class LakeHouseLocationArgs(
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LakeHouseLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LakeHouseLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.LakeHouseLocationArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeHouseLocationArgs].
 */
@PulumiTagMarker
public class LakeHouseLocationArgsBuilder internal constructor() {
    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("jbtxpluweafoqfrb")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("grwbusiilqpwvjlq")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'LakeHouseLocation'.
     */
    @JvmName("kwmieecfupssliam")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("iyowwroajpxjuqyr")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("jspwvrqntnlvwxbs")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'LakeHouseLocation'.
     */
    @JvmName("qagelvlcoplgcgxa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LakeHouseLocationArgs = LakeHouseLocationArgs(
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
