@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Log settings.
 * @property copyActivityLogSettings Specifies settings for copy activity log.
 * @property enableCopyActivityLog Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
 * @property logLocationSettings Log location settings customer needs to provide when enabling log.
 */
public data class LogSettingsArgs(
    public val copyActivityLogSettings: Output<CopyActivityLogSettingsArgs>? = null,
    public val enableCopyActivityLog: Output<Any>? = null,
    public val logLocationSettings: Output<LogLocationSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LogSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LogSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.LogSettingsArgs.builder()
            .copyActivityLogSettings(
                copyActivityLogSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableCopyActivityLog(enableCopyActivityLog?.applyValue({ args0 -> args0 }))
            .logLocationSettings(
                logLocationSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LogSettingsArgs].
 */
@PulumiTagMarker
public class LogSettingsArgsBuilder internal constructor() {
    private var copyActivityLogSettings: Output<CopyActivityLogSettingsArgs>? = null

    private var enableCopyActivityLog: Output<Any>? = null

    private var logLocationSettings: Output<LogLocationSettingsArgs>? = null

    /**
     * @param value Specifies settings for copy activity log.
     */
    @JvmName("hnoheqdnugvdagqk")
    public suspend fun copyActivityLogSettings(`value`: Output<CopyActivityLogSettingsArgs>) {
        this.copyActivityLogSettings = value
    }

    /**
     * @param value Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("sviowsggkgdjpdnd")
    public suspend fun enableCopyActivityLog(`value`: Output<Any>) {
        this.enableCopyActivityLog = value
    }

    /**
     * @param value Log location settings customer needs to provide when enabling log.
     */
    @JvmName("pmfflvtaoclldwkq")
    public suspend fun logLocationSettings(`value`: Output<LogLocationSettingsArgs>) {
        this.logLocationSettings = value
    }

    /**
     * @param value Specifies settings for copy activity log.
     */
    @JvmName("ffxqpdvxwupipwtt")
    public suspend fun copyActivityLogSettings(`value`: CopyActivityLogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyActivityLogSettings = mapped
    }

    /**
     * @param argument Specifies settings for copy activity log.
     */
    @JvmName("dvmdnbaciiudaowg")
    public suspend fun copyActivityLogSettings(argument: suspend CopyActivityLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CopyActivityLogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.copyActivityLogSettings = mapped
    }

    /**
     * @param value Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bpyseatwopfkyvch")
    public suspend fun enableCopyActivityLog(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCopyActivityLog = mapped
    }

    /**
     * @param value Log location settings customer needs to provide when enabling log.
     */
    @JvmName("kinyykgbkfwxblax")
    public suspend fun logLocationSettings(`value`: LogLocationSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLocationSettings = mapped
    }

    /**
     * @param argument Log location settings customer needs to provide when enabling log.
     */
    @JvmName("wcpmawjiqjaccoop")
    public suspend fun logLocationSettings(argument: suspend LogLocationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogLocationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logLocationSettings = mapped
    }

    internal fun build(): LogSettingsArgs = LogSettingsArgs(
        copyActivityLogSettings = copyActivityLogSettings,
        enableCopyActivityLog = enableCopyActivityLog,
        logLocationSettings = logLocationSettings ?: throw PulumiNullFieldException("logLocationSettings"),
    )
}
