@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * CDC Policy.
 * @property mode Mode of running the CDC: batch vs continuous.
 * @property recurrence Defines the frequency and interval for running the CDC for batch mode.
 */
public data class MapperPolicyArgs(
    public val mode: Output<String>? = null,
    public val recurrence: Output<MapperPolicyRecurrenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperPolicyArgs.builder()
            .mode(mode?.applyValue({ args0 -> args0 }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MapperPolicyArgs].
 */
@PulumiTagMarker
public class MapperPolicyArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var recurrence: Output<MapperPolicyRecurrenceArgs>? = null

    /**
     * @param value Mode of running the CDC: batch vs continuous.
     */
    @JvmName("cwroiancwdvjtyrr")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Defines the frequency and interval for running the CDC for batch mode.
     */
    @JvmName("tvkmjtvprnqksmlr")
    public suspend fun recurrence(`value`: Output<MapperPolicyRecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value Mode of running the CDC: batch vs continuous.
     */
    @JvmName("cjdvsvscnpevqybr")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the frequency and interval for running the CDC for batch mode.
     */
    @JvmName("xoehkbxvrruvlutb")
    public suspend fun recurrence(`value`: MapperPolicyRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument Defines the frequency and interval for running the CDC for batch mode.
     */
    @JvmName("tdyoojubxnlteies")
    public suspend fun recurrence(argument: suspend MapperPolicyRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = MapperPolicyRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    internal fun build(): MapperPolicyArgs = MapperPolicyArgs(
        mode = mode,
        recurrence = recurrence,
    )
}
