@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * CDC table details.
 * @property dslConnectorProperties List of name/value pairs for connection properties.
 * @property name Name of the table.
 * @property schema List of columns for the source table.
 */
public data class MapperTableArgs(
    public val dslConnectorProperties: Output<List<MapperDslConnectorPropertiesArgs>>? = null,
    public val name: Output<String>? = null,
    public val schema: Output<List<MapperTableSchemaArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperTableArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperTableArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperTableArgs.builder()
            .dslConnectorProperties(
                dslConnectorProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .schema(
                schema?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperTableArgs].
 */
@PulumiTagMarker
public class MapperTableArgsBuilder internal constructor() {
    private var dslConnectorProperties: Output<List<MapperDslConnectorPropertiesArgs>>? = null

    private var name: Output<String>? = null

    private var schema: Output<List<MapperTableSchemaArgs>>? = null

    /**
     * @param value List of name/value pairs for connection properties.
     */
    @JvmName("ocjfvrksnceplcti")
    public suspend fun dslConnectorProperties(`value`: Output<List<MapperDslConnectorPropertiesArgs>>) {
        this.dslConnectorProperties = value
    }

    @JvmName("oiyhgtladpncybdt")
    public suspend fun dslConnectorProperties(vararg values: Output<MapperDslConnectorPropertiesArgs>) {
        this.dslConnectorProperties = Output.all(values.asList())
    }

    /**
     * @param values List of name/value pairs for connection properties.
     */
    @JvmName("oukedmhjywxcdedb")
    public suspend fun dslConnectorProperties(values: List<Output<MapperDslConnectorPropertiesArgs>>) {
        this.dslConnectorProperties = Output.all(values)
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("bcyrhaxkwwoxaoap")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of columns for the source table.
     */
    @JvmName("cyxaabunjfjxkgiq")
    public suspend fun schema(`value`: Output<List<MapperTableSchemaArgs>>) {
        this.schema = value
    }

    @JvmName("iumshykkjobbwhss")
    public suspend fun schema(vararg values: Output<MapperTableSchemaArgs>) {
        this.schema = Output.all(values.asList())
    }

    /**
     * @param values List of columns for the source table.
     */
    @JvmName("etkchycijwssqwgo")
    public suspend fun schema(values: List<Output<MapperTableSchemaArgs>>) {
        this.schema = Output.all(values)
    }

    /**
     * @param value List of name/value pairs for connection properties.
     */
    @JvmName("lntfnpkxqpdpgouk")
    public suspend fun dslConnectorProperties(`value`: List<MapperDslConnectorPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("yexlnrmsaakqvddy")
    public suspend fun dslConnectorProperties(argument: List<suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("tyuqmvpbsksarpjy")
    public suspend fun dslConnectorProperties(vararg argument: suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dslConnectorProperties = mapped
    }

    /**
     * @param argument List of name/value pairs for connection properties.
     */
    @JvmName("wpvgpydlhkpfpqne")
    public suspend fun dslConnectorProperties(argument: suspend MapperDslConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MapperDslConnectorPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dslConnectorProperties = mapped
    }

    /**
     * @param values List of name/value pairs for connection properties.
     */
    @JvmName("pgfukxcfgxaekhmf")
    public suspend fun dslConnectorProperties(vararg values: MapperDslConnectorPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dslConnectorProperties = mapped
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("ryptyjyjlmdqufiq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of columns for the source table.
     */
    @JvmName("gvxgmkngswsvvdff")
    public suspend fun schema(`value`: List<MapperTableSchemaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument List of columns for the source table.
     */
    @JvmName("uyhtgnakeuvgretk")
    public suspend fun schema(argument: List<suspend MapperTableSchemaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperTableSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param argument List of columns for the source table.
     */
    @JvmName("girrlragjojiawgu")
    public suspend fun schema(vararg argument: suspend MapperTableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MapperTableSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param argument List of columns for the source table.
     */
    @JvmName("rfhmssogpvfwcxgm")
    public suspend fun schema(argument: suspend MapperTableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MapperTableSchemaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param values List of columns for the source table.
     */
    @JvmName("kixwiljureqkdgww")
    public suspend fun schema(vararg values: MapperTableSchemaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): MapperTableArgs = MapperTableArgs(
        dslConnectorProperties = dslConnectorProperties,
        name = name,
        schema = schema,
    )
}
