@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MappingDataFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Mapping data flow.
 * @property annotations List of tags that can be used for describing the data flow.
 * @property description The description of the data flow.
 * @property folder The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property script DataFlow script.
 * @property scriptLines Data flow script lines.
 * @property sinks List of sinks in data flow.
 * @property sources List of sources in data flow.
 * @property transformations List of transformations in data flow.
 * @property type Type of data flow.
 * Expected value is 'MappingDataFlow'.
 */
public data class MappingDataFlowArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DataFlowFolderArgs>? = null,
    public val script: Output<String>? = null,
    public val scriptLines: Output<List<String>>? = null,
    public val sinks: Output<List<DataFlowSinkArgs>>? = null,
    public val sources: Output<List<DataFlowSourceArgs>>? = null,
    public val transformations: Output<List<TransformationArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MappingDataFlowArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MappingDataFlowArgs =
        com.pulumi.azurenative.datafactory.inputs.MappingDataFlowArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .script(script?.applyValue({ args0 -> args0 }))
            .scriptLines(scriptLines?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sinks(sinks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .transformations(
                transformations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MappingDataFlowArgs].
 */
@PulumiTagMarker
public class MappingDataFlowArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DataFlowFolderArgs>? = null

    private var script: Output<String>? = null

    private var scriptLines: Output<List<String>>? = null

    private var sinks: Output<List<DataFlowSinkArgs>>? = null

    private var sources: Output<List<DataFlowSourceArgs>>? = null

    private var transformations: Output<List<TransformationArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("gilapijkurshmcjq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ncqfguxabmtruaer")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("rfgmmwsqowiwbooe")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("chignsddgijedewj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("qpfaotsmkbrqptvu")
    public suspend fun folder(`value`: Output<DataFlowFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value DataFlow script.
     */
    @JvmName("iahnkwopsqtpkaqn")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Data flow script lines.
     */
    @JvmName("cptendhcumkbhbnh")
    public suspend fun scriptLines(`value`: Output<List<String>>) {
        this.scriptLines = value
    }

    @JvmName("rsujmqiwlbjbvrrl")
    public suspend fun scriptLines(vararg values: Output<String>) {
        this.scriptLines = Output.all(values.asList())
    }

    /**
     * @param values Data flow script lines.
     */
    @JvmName("tfrnloffnfgjnmxg")
    public suspend fun scriptLines(values: List<Output<String>>) {
        this.scriptLines = Output.all(values)
    }

    /**
     * @param value List of sinks in data flow.
     */
    @JvmName("vjopadjisvdskhjw")
    public suspend fun sinks(`value`: Output<List<DataFlowSinkArgs>>) {
        this.sinks = value
    }

    @JvmName("wrkdxilletxvjdsb")
    public suspend fun sinks(vararg values: Output<DataFlowSinkArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values List of sinks in data flow.
     */
    @JvmName("odprqquexefdfvpr")
    public suspend fun sinks(values: List<Output<DataFlowSinkArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value List of sources in data flow.
     */
    @JvmName("lvkmtrhjhhyositm")
    public suspend fun sources(`value`: Output<List<DataFlowSourceArgs>>) {
        this.sources = value
    }

    @JvmName("ijvomoholcvmeltw")
    public suspend fun sources(vararg values: Output<DataFlowSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values List of sources in data flow.
     */
    @JvmName("mtokblupitpaxpyy")
    public suspend fun sources(values: List<Output<DataFlowSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value List of transformations in data flow.
     */
    @JvmName("lbloplgokgwpmulb")
    public suspend fun transformations(`value`: Output<List<TransformationArgs>>) {
        this.transformations = value
    }

    @JvmName("epvewvgeuvvkehff")
    public suspend fun transformations(vararg values: Output<TransformationArgs>) {
        this.transformations = Output.all(values.asList())
    }

    /**
     * @param values List of transformations in data flow.
     */
    @JvmName("vrociwngfnuwaurm")
    public suspend fun transformations(values: List<Output<TransformationArgs>>) {
        this.transformations = Output.all(values)
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'MappingDataFlow'.
     */
    @JvmName("tjbskpccdljwcpdc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("avmqblbhrbncybjh")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("thfroinlrpdgbxhk")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("mjwyojyiegxkfkql")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("wdbanbooijlfnweg")
    public suspend fun folder(`value`: DataFlowFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("hqmrccwapxnfgdws")
    public suspend fun folder(argument: suspend DataFlowFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value DataFlow script.
     */
    @JvmName("vdymiqmuvliyeyau")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Data flow script lines.
     */
    @JvmName("nxytptdbhdehdmkb")
    public suspend fun scriptLines(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptLines = mapped
    }

    /**
     * @param values Data flow script lines.
     */
    @JvmName("dpvmgwmwunnbksxa")
    public suspend fun scriptLines(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptLines = mapped
    }

    /**
     * @param value List of sinks in data flow.
     */
    @JvmName("wgdagwkeipdsrndw")
    public suspend fun sinks(`value`: List<DataFlowSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in data flow.
     */
    @JvmName("dooayskacfbmiuxl")
    public suspend fun sinks(argument: List<suspend DataFlowSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataFlowSinkArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in data flow.
     */
    @JvmName("dbsxwdbykqsethxd")
    public suspend fun sinks(vararg argument: suspend DataFlowSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataFlowSinkArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in data flow.
     */
    @JvmName("teyniegtphmglmip")
    public suspend fun sinks(argument: suspend DataFlowSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values List of sinks in data flow.
     */
    @JvmName("rpqpgxifmgdawnha")
    public suspend fun sinks(vararg values: DataFlowSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value List of sources in data flow.
     */
    @JvmName("yhpbtgcrqgeytpuc")
    public suspend fun sources(`value`: List<DataFlowSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument List of sources in data flow.
     */
    @JvmName("dpaboesrsauukeuf")
    public suspend fun sources(argument: List<suspend DataFlowSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataFlowSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in data flow.
     */
    @JvmName("jaywqgnjptoxwbio")
    public suspend fun sources(vararg argument: suspend DataFlowSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataFlowSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in data flow.
     */
    @JvmName("pdqbxagbpiqsbhlt")
    public suspend fun sources(argument: suspend DataFlowSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values List of sources in data flow.
     */
    @JvmName("apwneaveqafuifti")
    public suspend fun sources(vararg values: DataFlowSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value List of transformations in data flow.
     */
    @JvmName("tehhqjvymtlcmunl")
    public suspend fun transformations(`value`: List<TransformationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in data flow.
     */
    @JvmName("ddsaaufdcnypxyie")
    public suspend fun transformations(argument: List<suspend TransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in data flow.
     */
    @JvmName("bovetmrrxkwufwlq")
    public suspend fun transformations(vararg argument: suspend TransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in data flow.
     */
    @JvmName("rvwqlecglsyjysyo")
    public suspend fun transformations(argument: suspend TransformationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TransformationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param values List of transformations in data flow.
     */
    @JvmName("yqovgkkyyhapscgo")
    public suspend fun transformations(vararg values: TransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformations = mapped
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'MappingDataFlow'.
     */
    @JvmName("lxpmgnshlfgsedks")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MappingDataFlowArgs = MappingDataFlowArgs(
        annotations = annotations,
        description = description,
        folder = folder,
        script = script,
        scriptLines = scriptLines,
        sinks = sinks,
        sources = sources,
        transformations = transformations,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
