@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MongoDbCursorMethodsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cursor methods for Mongodb query
 * @property limit Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with resultType integer).
 * @property project Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents, omit this parameter. Type: string (or Expression with resultType string).
 * @property skip Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing paginated results. Type: integer (or Expression with resultType integer).
 * @property sort Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string). Type: string (or Expression with resultType string).
 */
public data class MongoDbCursorMethodsPropertiesArgs(
    public val limit: Output<Any>? = null,
    public val project: Output<Any>? = null,
    public val skip: Output<Any>? = null,
    public val sort: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MongoDbCursorMethodsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MongoDbCursorMethodsPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.MongoDbCursorMethodsPropertiesArgs.builder()
            .limit(limit?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .skip(skip?.applyValue({ args0 -> args0 }))
            .sort(sort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbCursorMethodsPropertiesArgs].
 */
@PulumiTagMarker
public class MongoDbCursorMethodsPropertiesArgsBuilder internal constructor() {
    private var limit: Output<Any>? = null

    private var project: Output<Any>? = null

    private var skip: Output<Any>? = null

    private var sort: Output<Any>? = null

    /**
     * @param value Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ucyaaxskwtpsxhox")
    public suspend fun limit(`value`: Output<Any>) {
        this.limit = value
    }

    /**
     * @param value Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents, omit this parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("uxpatulqbhgpkalq")
    public suspend fun project(`value`: Output<Any>) {
        this.project = value
    }

    /**
     * @param value Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing paginated results. Type: integer (or Expression with resultType integer).
     */
    @JvmName("sunkitevoeqcpahv")
    public suspend fun skip(`value`: Output<Any>) {
        this.skip = value
    }

    /**
     * @param value Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string). Type: string (or Expression with resultType string).
     */
    @JvmName("eiuvkbojvibygkoy")
    public suspend fun sort(`value`: Output<Any>) {
        this.sort = value
    }

    /**
     * @param value Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ieeuegxjadqbitkk")
    public suspend fun limit(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents, omit this parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("xuueutmwaunrxqnq")
    public suspend fun project(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing paginated results. Type: integer (or Expression with resultType integer).
     */
    @JvmName("padwhshdmqnvsfeo")
    public suspend fun skip(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skip = mapped
    }

    /**
     * @param value Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string). Type: string (or Expression with resultType string).
     */
    @JvmName("civjrcuvlentlxnq")
    public suspend fun sort(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sort = mapped
    }

    internal fun build(): MongoDbCursorMethodsPropertiesArgs = MongoDbCursorMethodsPropertiesArgs(
        limit = limit,
        project = project,
        skip = skip,
        sort = sort,
    )
}
