@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MongoDbLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.MongoDbAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for MongoDb data source.
 * @property allowSelfSignedServerCert Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authSource Database to verify the username and password. Type: string (or Expression with resultType string).
 * @property authenticationType The authentication type to be used to connect to the MongoDB database.
 * @property connectVia The integration runtime reference.
 * @property databaseName The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property enableSsl Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password for authentication.
 * @property port The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property server The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'MongoDb'.
 * @property username Username for authentication. Type: string (or Expression with resultType string).
 */
public data class MongoDbLinkedServiceArgs(
    public val allowSelfSignedServerCert: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authSource: Output<Any>? = null,
    public val authenticationType: Output<Either<String, MongoDbAuthenticationType>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val databaseName: Output<Any>,
    public val description: Output<String>? = null,
    public val enableSsl: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val server: Output<Any>,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MongoDbLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MongoDbLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.MongoDbLinkedServiceArgs.builder()
            .allowSelfSignedServerCert(allowSelfSignedServerCert?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authSource(authSource?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableSsl(enableSsl?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbLinkedServiceArgs].
 */
@PulumiTagMarker
public class MongoDbLinkedServiceArgsBuilder internal constructor() {
    private var allowSelfSignedServerCert: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authSource: Output<Any>? = null

    private var authenticationType: Output<Either<String, MongoDbAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var databaseName: Output<Any>? = null

    private var description: Output<String>? = null

    private var enableSsl: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var server: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("crxtkjxloirotfba")
    public suspend fun allowSelfSignedServerCert(`value`: Output<Any>) {
        this.allowSelfSignedServerCert = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("efcglkvmlknnilfr")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("rotrisbxtiuimymi")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("pgodcwavpfwrfqgx")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Database to verify the username and password. Type: string (or Expression with resultType string).
     */
    @JvmName("whualutnddqnlfmd")
    public suspend fun authSource(`value`: Output<Any>) {
        this.authSource = value
    }

    /**
     * @param value The authentication type to be used to connect to the MongoDB database.
     */
    @JvmName("agbhscnywxesjckd")
    public suspend fun authenticationType(`value`: Output<Either<String, MongoDbAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("npbqpkpukoeyndre")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("reglebrrqrtxqvpc")
    public suspend fun databaseName(`value`: Output<Any>) {
        this.databaseName = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rcxprcbuorqnrxkr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ndtkbalxkskabvqu")
    public suspend fun enableSsl(`value`: Output<Any>) {
        this.enableSsl = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("jtmrqiirtqyorjma")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hkwxrghwvdteydhw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("dadquifvrnrpjdel")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("diaiyvkifkirvppe")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
     */
    @JvmName("bwfehamxxghfykeg")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MongoDb'.
     */
    @JvmName("twcskvyhwscwcdrr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username for authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("kyqlwbtkgivvhlfk")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("thsaeydtvdblliyk")
    public suspend fun allowSelfSignedServerCert(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSelfSignedServerCert = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mfukxltodnikjtop")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("bqhvaogtdogqcbhc")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Database to verify the username and password. Type: string (or Expression with resultType string).
     */
    @JvmName("mfmjmenbcdguwyso")
    public suspend fun authSource(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authSource = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the MongoDB database.
     */
    @JvmName("idnjsrenmfenthij")
    public suspend fun authenticationType(`value`: Either<String, MongoDbAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the MongoDB database.
     */
    @JvmName("plibcuckvdgsyyhy")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MongoDbAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the MongoDB database.
     */
    @JvmName("mjsotnkckfhxteni")
    public fun authenticationType(`value`: MongoDbAuthenticationType) {
        val toBeMapped = Either.ofRight<String, MongoDbAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("qdqrsdenpkikrmic")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("pnyosohtvvfmiupb")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("ippqmapotptjxvxo")
    public suspend fun databaseName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ruyxwbudbvouxkpo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("evhywqqcevatbssd")
    public suspend fun enableSsl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsl = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("gvakmbxbglultcti")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("pdlldsxvjamvhjxh")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("kpjilijafrgjqads")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ahomjugyykcmncpl")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("piixtsbsbqvnjlwy")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("vtqtorqyftfkjqdc")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("ppfkrujroiothcvc")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("pyuukvqbrjifkdhx")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
     */
    @JvmName("lheachwxsaogdqug")
    public suspend fun server(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MongoDb'.
     */
    @JvmName("icmmjyxdjipmwgmx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username for authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("jnpiegbcorsfrpwp")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): MongoDbLinkedServiceArgs = MongoDbLinkedServiceArgs(
        allowSelfSignedServerCert = allowSelfSignedServerCert,
        annotations = annotations,
        authSource = authSource,
        authenticationType = authenticationType,
        connectVia = connectVia,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        description = description,
        enableSsl = enableSsl,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        port = port,
        server = server ?: throw PulumiNullFieldException("server"),
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
