@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.NetezzaPartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for Netezza source partitioning.
 * @property partitionColumnName The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class NetezzaPartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.NetezzaPartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.NetezzaPartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.NetezzaPartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetezzaPartitionSettingsArgs].
 */
@PulumiTagMarker
public class NetezzaPartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("qmmuavfsoogvming")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("ruppohfbismuivux")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("nscdnikbtdadouvu")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("jedmrgevvlsgpwta")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("hdhuhcpxouhhqrdr")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("qyscdragivknvgjc")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): NetezzaPartitionSettingsArgs = NetezzaPartitionSettingsArgs(
        partitionColumnName = partitionColumnName,
        partitionLowerBound = partitionLowerBound,
        partitionUpperBound = partitionUpperBound,
    )
}
