@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ParameterSpecificationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of a single parameter for an entity.
 * @property defaultValue Default value of parameter.
 * @property type Parameter type.
 */
public data class ParameterSpecificationArgs(
    public val defaultValue: Output<Any>? = null,
    public val type: Output<Either<String, ParameterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ParameterSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ParameterSpecificationArgs =
        com.pulumi.azurenative.datafactory.inputs.ParameterSpecificationArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterSpecificationArgs].
 */
@PulumiTagMarker
public class ParameterSpecificationArgsBuilder internal constructor() {
    private var defaultValue: Output<Any>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    /**
     * @param value Default value of parameter.
     */
    @JvmName("oifarrfimftprkkj")
    public suspend fun defaultValue(`value`: Output<Any>) {
        this.defaultValue = value
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("egwoxueiwtcoursr")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value Default value of parameter.
     */
    @JvmName("qfhvwwcvqebgotnq")
    public suspend fun defaultValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("yabhoyueqvsoafnt")
    public suspend fun type(`value`: Either<String, ParameterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("rtjyxwwgnctbwhjl")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("veaualtvqnngrbdl")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParameterSpecificationArgs = ParameterSpecificationArgs(
        defaultValue = defaultValue,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
