@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PipelineFolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
 * @property name The name of the folder that this Pipeline is in.
 */
public data class PipelineFolderArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PipelineFolderArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PipelineFolderArgs =
        com.pulumi.azurenative.datafactory.inputs.PipelineFolderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineFolderArgs].
 */
@PulumiTagMarker
public class PipelineFolderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the folder that this Pipeline is in.
     */
    @JvmName("woeulawtuoyladua")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the folder that this Pipeline is in.
     */
    @JvmName("ginqvcnclhtdohvy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PipelineFolderArgs = PipelineFolderArgs(
        name = name,
    )
}
