@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PostgreSqlV2LinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for PostgreSQLV2 data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property commandTimeout The time to wait (in seconds) while trying to execute a command before terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
 * @property connectVia The integration runtime reference.
 * @property connectionTimeout The time to wait (in seconds) while trying to establish a connection before terminating the attempt and generating an error. Type: integer.
 * @property database Database name for connection. Type: string.
 * @property description Linked service description.
 * @property encoding Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string data. Type: string
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property logParameters When enabled, parameter values are logged when commands are executed. Type: boolean.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string. Type: string.
 * @property pooling Whether connection pooling should be used. Type: boolean.
 * @property port The port for the connection. Type: integer.
 * @property readBufferSize Determines the size of the internal buffer uses when reading. Increasing may improve performance if transferring large values from the database. Type: integer.
 * @property schema Sets the schema search path. Type: string.
 * @property server Server name for connection. Type: string.
 * @property sslCertificate Location of a client certificate to be sent to the server. Type: string.
 * @property sslKey Location of a client key for a client certificate to be sent to the server. Type: string.
 * @property sslMode SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4: verify-ca, 5: verify-full. Type: integer.
 * @property sslPassword Password for a key for a client certificate. Type: string.
 * @property timezone Gets or sets the session timezone. Type: string.
 * @property trustServerCertificate Whether to trust the server certificate without validating it. Type: boolean.
 * @property type Type of linked service.
 * Expected value is 'PostgreSqlV2'.
 * @property username Username for authentication. Type: string.
 */
public data class PostgreSqlV2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val commandTimeout: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionTimeout: Output<Any>? = null,
    public val database: Output<Any>,
    public val description: Output<String>? = null,
    public val encoding: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val logParameters: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val pooling: Output<Any>? = null,
    public val port: Output<Any>? = null,
    public val readBufferSize: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val server: Output<Any>,
    public val sslCertificate: Output<Any>? = null,
    public val sslKey: Output<Any>? = null,
    public val sslMode: Output<Any>,
    public val sslPassword: Output<Any>? = null,
    public val timezone: Output<Any>? = null,
    public val trustServerCertificate: Output<Any>? = null,
    public val type: Output<String>,
    public val username: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PostgreSqlV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PostgreSqlV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.PostgreSqlV2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commandTimeout(commandTimeout?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionTimeout(connectionTimeout?.applyValue({ args0 -> args0 }))
            .database(database.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .logParameters(logParameters?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pooling(pooling?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .readBufferSize(readBufferSize?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .sslCertificate(sslCertificate?.applyValue({ args0 -> args0 }))
            .sslKey(sslKey?.applyValue({ args0 -> args0 }))
            .sslMode(sslMode.applyValue({ args0 -> args0 }))
            .sslPassword(sslPassword?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PostgreSqlV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class PostgreSqlV2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var commandTimeout: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionTimeout: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encoding: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var logParameters: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var pooling: Output<Any>? = null

    private var port: Output<Any>? = null

    private var readBufferSize: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var server: Output<Any>? = null

    private var sslCertificate: Output<Any>? = null

    private var sslKey: Output<Any>? = null

    private var sslMode: Output<Any>? = null

    private var sslPassword: Output<Any>? = null

    private var timezone: Output<Any>? = null

    private var trustServerCertificate: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("jhdesiogvvkdkxeq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("vxvrmwayjrtpyjet")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("lhnrepthkoxwvfbx")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The time to wait (in seconds) while trying to execute a command before terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     */
    @JvmName("bcjpfkrjumsepjxi")
    public suspend fun commandTimeout(`value`: Output<Any>) {
        this.commandTimeout = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("kihhvtaeajhvkyaq")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The time to wait (in seconds) while trying to establish a connection before terminating the attempt and generating an error. Type: integer.
     */
    @JvmName("ofqjqdiptsjpmbcq")
    public suspend fun connectionTimeout(`value`: Output<Any>) {
        this.connectionTimeout = value
    }

    /**
     * @param value Database name for connection. Type: string.
     */
    @JvmName("ddqyvsqbnhjkbnhj")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("gdklfpobgobbcwlt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string data. Type: string
     */
    @JvmName("jnhmsawgxvlhihtl")
    public suspend fun encoding(`value`: Output<Any>) {
        this.encoding = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pbcdhrtvsgpvajlb")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value When enabled, parameter values are logged when commands are executed. Type: boolean.
     */
    @JvmName("nvnswoyhedlysoch")
    public suspend fun logParameters(`value`: Output<Any>) {
        this.logParameters = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("aersodgguwcbccud")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string. Type: string.
     */
    @JvmName("qkundumshvddqhal")
    public suspend fun password(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.password = value
    }

    /**
     * @param value Whether connection pooling should be used. Type: boolean.
     */
    @JvmName("ukbmhshvwiohhgju")
    public suspend fun pooling(`value`: Output<Any>) {
        this.pooling = value
    }

    /**
     * @param value The port for the connection. Type: integer.
     */
    @JvmName("llowdhqvusoqgijd")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value Determines the size of the internal buffer uses when reading. Increasing may improve performance if transferring large values from the database. Type: integer.
     */
    @JvmName("cqkiilovlcvtcmse")
    public suspend fun readBufferSize(`value`: Output<Any>) {
        this.readBufferSize = value
    }

    /**
     * @param value Sets the schema search path. Type: string.
     */
    @JvmName("stiairhagbsipjlb")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Server name for connection. Type: string.
     */
    @JvmName("cbsawidsfdpexkyk")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Location of a client certificate to be sent to the server. Type: string.
     */
    @JvmName("bblcwxsjgnqlhxpx")
    public suspend fun sslCertificate(`value`: Output<Any>) {
        this.sslCertificate = value
    }

    /**
     * @param value Location of a client key for a client certificate to be sent to the server. Type: string.
     */
    @JvmName("vwpsdaiwvfkcavvi")
    public suspend fun sslKey(`value`: Output<Any>) {
        this.sslKey = value
    }

    /**
     * @param value SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4: verify-ca, 5: verify-full. Type: integer.
     */
    @JvmName("rrfqwocdguxfmsds")
    public suspend fun sslMode(`value`: Output<Any>) {
        this.sslMode = value
    }

    /**
     * @param value Password for a key for a client certificate. Type: string.
     */
    @JvmName("npmhagmqgqeybqax")
    public suspend fun sslPassword(`value`: Output<Any>) {
        this.sslPassword = value
    }

    /**
     * @param value Gets or sets the session timezone. Type: string.
     */
    @JvmName("iufjjyemdsvsvata")
    public suspend fun timezone(`value`: Output<Any>) {
        this.timezone = value
    }

    /**
     * @param value Whether to trust the server certificate without validating it. Type: boolean.
     */
    @JvmName("anvwufgvsxmdyaxd")
    public suspend fun trustServerCertificate(`value`: Output<Any>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'PostgreSqlV2'.
     */
    @JvmName("mgkdkdwebldwqgwb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username for authentication. Type: string.
     */
    @JvmName("ffcwkwhwhkcphpfc")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vtwibiqaigmjpqwy")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ltgftrwmfbufqrid")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The time to wait (in seconds) while trying to execute a command before terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     */
    @JvmName("tuurglqpfqikthbp")
    public suspend fun commandTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandTimeout = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("outjjxjvptdcbdec")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("xqxiglmlprchewgi")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The time to wait (in seconds) while trying to establish a connection before terminating the attempt and generating an error. Type: integer.
     */
    @JvmName("wemrahpbeuyxonyh")
    public suspend fun connectionTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeout = mapped
    }

    /**
     * @param value Database name for connection. Type: string.
     */
    @JvmName("sttrrcmtajetjyql")
    public suspend fun database(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rwfrmcdvofbnfalh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string data. Type: string
     */
    @JvmName("bbnsxhgnkmnvwgib")
    public suspend fun encoding(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ecmwihtcrcoaoikm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value When enabled, parameter values are logged when commands are executed. Type: boolean.
     */
    @JvmName("jvvrwdvmyvhpygjs")
    public suspend fun logParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logParameters = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("bftbnbjmuwftljrm")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ebvvxcdggoapmyaa")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("woakvubgdejxvkds")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string. Type: string.
     */
    @JvmName("nggvxoaxiugdonwg")
    public suspend fun password(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of password in connection string. Type: string.
     */
    @JvmName("laphgiabsaurkqhx")
    public suspend fun password(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value Whether connection pooling should be used. Type: boolean.
     */
    @JvmName("mlpyhdtibotddcln")
    public suspend fun pooling(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pooling = mapped
    }

    /**
     * @param value The port for the connection. Type: integer.
     */
    @JvmName("jrcbfkmqebkodckg")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Determines the size of the internal buffer uses when reading. Increasing may improve performance if transferring large values from the database. Type: integer.
     */
    @JvmName("vfnlkxehpnlefljv")
    public suspend fun readBufferSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readBufferSize = mapped
    }

    /**
     * @param value Sets the schema search path. Type: string.
     */
    @JvmName("bvclkrvffirpkvvi")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Server name for connection. Type: string.
     */
    @JvmName("nsktalgpiwwnmpvw")
    public suspend fun server(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Location of a client certificate to be sent to the server. Type: string.
     */
    @JvmName("bwcogujhfbakemeu")
    public suspend fun sslCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificate = mapped
    }

    /**
     * @param value Location of a client key for a client certificate to be sent to the server. Type: string.
     */
    @JvmName("fusunkokhatgcevu")
    public suspend fun sslKey(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslKey = mapped
    }

    /**
     * @param value SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4: verify-ca, 5: verify-full. Type: integer.
     */
    @JvmName("fpmytlvjqyafnwrp")
    public suspend fun sslMode(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslMode = mapped
    }

    /**
     * @param value Password for a key for a client certificate. Type: string.
     */
    @JvmName("cxyphsflmyphbmxh")
    public suspend fun sslPassword(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPassword = mapped
    }

    /**
     * @param value Gets or sets the session timezone. Type: string.
     */
    @JvmName("enigiqeyqicptnsg")
    public suspend fun timezone(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value Whether to trust the server certificate without validating it. Type: boolean.
     */
    @JvmName("mrumxdagbjlrbceh")
    public suspend fun trustServerCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'PostgreSqlV2'.
     */
    @JvmName("odsvktxdyudpqoas")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username for authentication. Type: string.
     */
    @JvmName("tgraflnwgglefiyg")
    public suspend fun username(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): PostgreSqlV2LinkedServiceArgs = PostgreSqlV2LinkedServiceArgs(
        annotations = annotations,
        commandTimeout = commandTimeout,
        connectVia = connectVia,
        connectionTimeout = connectionTimeout,
        database = database ?: throw PulumiNullFieldException("database"),
        description = description,
        encoding = encoding,
        encryptedCredential = encryptedCredential,
        logParameters = logParameters,
        parameters = parameters,
        password = password,
        pooling = pooling,
        port = port,
        readBufferSize = readBufferSize,
        schema = schema,
        server = server ?: throw PulumiNullFieldException("server"),
        sslCertificate = sslCertificate,
        sslKey = sslKey,
        sslMode = sslMode ?: throw PulumiNullFieldException("sslMode"),
        sslPassword = sslPassword,
        timezone = timezone,
        trustServerCertificate = trustServerCertificate,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
