@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PrivateLinkConnectionApprovalRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A request to approve or reject a private endpoint connection
 * @property privateEndpoint The resource of private endpoint.
 * @property privateLinkServiceConnectionState The state of a private link connection
 */
public data class PrivateLinkConnectionApprovalRequestArgs(
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PrivateLinkConnectionApprovalRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PrivateLinkConnectionApprovalRequestArgs =
        com.pulumi.azurenative.datafactory.inputs.PrivateLinkConnectionApprovalRequestArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkConnectionApprovalRequestArgs].
 */
@PulumiTagMarker
public class PrivateLinkConnectionApprovalRequestArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null

    /**
     * @param value The resource of private endpoint.
     */
    @JvmName("rktstywejhticapn")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("tskslcgqrwsacakg")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The resource of private endpoint.
     */
    @JvmName("tebugwujtfkkbnip")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The resource of private endpoint.
     */
    @JvmName("odcajonrilsjiesc")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("utybfncobmsljqgp")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The state of a private link connection
     */
    @JvmName("nyeigruemquievki")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateLinkConnectionApprovalRequestArgs =
        PrivateLinkConnectionApprovalRequestArgs(
            privateEndpoint = privateEndpoint,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        )
}
