@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RedshiftUnloadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
 * @property bucketName The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
 * @property s3LinkedServiceName The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
 */
public data class RedshiftUnloadSettingsArgs(
    public val bucketName: Output<Any>,
    public val s3LinkedServiceName: Output<LinkedServiceReferenceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RedshiftUnloadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RedshiftUnloadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.RedshiftUnloadSettingsArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .s3LinkedServiceName(
                s3LinkedServiceName.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RedshiftUnloadSettingsArgs].
 */
@PulumiTagMarker
public class RedshiftUnloadSettingsArgsBuilder internal constructor() {
    private var bucketName: Output<Any>? = null

    private var s3LinkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    /**
     * @param value The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
     */
    @JvmName("ymjgoxchlgfgqmcw")
    public suspend fun bucketName(`value`: Output<Any>) {
        this.bucketName = value
    }

    /**
     * @param value The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
     */
    @JvmName("gfwjurpfypadkooq")
    public suspend fun s3LinkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.s3LinkedServiceName = value
    }

    /**
     * @param value The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
     */
    @JvmName("usgfjlbqjdppuhxg")
    public suspend fun bucketName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
     */
    @JvmName("jbirpyiofmtmfwli")
    public suspend fun s3LinkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3LinkedServiceName = mapped
    }

    /**
     * @param argument The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
     */
    @JvmName("agnjpjhhtdcetviy")
    public suspend fun s3LinkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3LinkedServiceName = mapped
    }

    internal fun build(): RedshiftUnloadSettingsArgs = RedshiftUnloadSettingsArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        s3LinkedServiceName = s3LinkedServiceName ?: throw PulumiNullFieldException("s3LinkedServiceName"),
    )
}
