@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RestServiceLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.RestServiceAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Rest Service linked service.
 * @property aadResourceId The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authHeaders The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType object).
 * @property authenticationType Type of authentication used to connect to the REST service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property clientId The client ID associated with your application. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret associated with your application.
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property enableServerCertificateValidation Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The password used in Basic authentication type.
 * @property resource The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
 * @property scope The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The application's key used in AadServicePrincipal authentication type.
 * @property tenant The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides. Type: string (or Expression with resultType string).
 * @property tokenEndpoint The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'RestService'.
 * @property url The base URL of the REST service. Type: string (or Expression with resultType string).
 * @property userName The user name used in Basic authentication type. Type: string (or Expression with resultType string).
 */
public data class RestServiceLinkedServiceArgs(
    public val aadResourceId: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authHeaders: Output<Any>? = null,
    public val authenticationType: Output<Either<String, RestServiceAuthenticationType>>,
    public val azureCloudType: Output<Any>? = null,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val enableServerCertificateValidation: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val resource: Output<Any>? = null,
    public val scope: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val tokenEndpoint: Output<Any>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RestServiceLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RestServiceLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.RestServiceLinkedServiceArgs.builder()
            .aadResourceId(aadResourceId?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authHeaders(authHeaders?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableServerCertificateValidation(
                enableServerCertificateValidation?.applyValue({ args0 ->
                    args0
                }),
            )
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resource(resource?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestServiceLinkedServiceArgs].
 */
@PulumiTagMarker
public class RestServiceLinkedServiceArgsBuilder internal constructor() {
    private var aadResourceId: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authHeaders: Output<Any>? = null

    private var authenticationType: Output<Either<String, RestServiceAuthenticationType>>? = null

    private var azureCloudType: Output<Any>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var enableServerCertificateValidation: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var resource: Output<Any>? = null

    private var scope: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var tokenEndpoint: Output<Any>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
     */
    @JvmName("cdrxallxbqgymdrl")
    public suspend fun aadResourceId(`value`: Output<Any>) {
        this.aadResourceId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ispxntswbmfrbipk")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("grykeapmhxcgwmcr")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("vcvxxnlmfgcjeocd")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType object).
     */
    @JvmName("goyssfmbffspjgow")
    public suspend fun authHeaders(`value`: Output<Any>) {
        this.authHeaders = value
    }

    /**
     * @param value Type of authentication used to connect to the REST service.
     */
    @JvmName("rypseijbnjsbbpff")
    public suspend fun authenticationType(`value`: Output<Either<String, RestServiceAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("onblayqfvvjfllgk")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The client ID associated with your application. Type: string (or Expression with resultType string).
     */
    @JvmName("yigimuksopydwllt")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret associated with your application.
     */
    @JvmName("uetvsgrmqbknctoh")
    public suspend fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("oydxoigaqomjglkw")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("cwtkcfdkkabjljou")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("stxvdvcanrgyhnwd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nyvrenevbdxnqyla")
    public suspend fun enableServerCertificateValidation(`value`: Output<Any>) {
        this.enableServerCertificateValidation = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ibbupflpodsgftur")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("xehtisqljhxppgqw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password used in Basic authentication type.
     */
    @JvmName("yrrxyxsecqcvrjhk")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
     */
    @JvmName("awadygkqxfnbuemo")
    public suspend fun resource(`value`: Output<Any>) {
        this.resource = value
    }

    /**
     * @param value The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with resultType string).
     */
    @JvmName("txlscwklsrwqtunc")
    public suspend fun scope(`value`: Output<Any>) {
        this.scope = value
    }

    /**
     * @param value The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType string).
     */
    @JvmName("lgdocdvbehkrnghv")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The application's key used in AadServicePrincipal authentication type.
     */
    @JvmName("xhcyokixdaejbwtl")
    public suspend fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("cxrxoetaiqqooxcg")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
     */
    @JvmName("sbsnfdhukokdsayq")
    public suspend fun tokenEndpoint(`value`: Output<Any>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'RestService'.
     */
    @JvmName("cbqessaktbgicfus")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The base URL of the REST service. Type: string (or Expression with resultType string).
     */
    @JvmName("rmjovwfgahibdqsj")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value The user name used in Basic authentication type. Type: string (or Expression with resultType string).
     */
    @JvmName("yjchcdffyenjheqa")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
     */
    @JvmName("vxfotcmrpsnnjowt")
    public suspend fun aadResourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadResourceId = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lacililmjglsjgqc")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("iqomiraehirrbthl")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType object).
     */
    @JvmName("pbcblnupytalltkl")
    public suspend fun authHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authHeaders = mapped
    }

    /**
     * @param value Type of authentication used to connect to the REST service.
     */
    @JvmName("diasamajqxhcapof")
    public suspend fun authenticationType(`value`: Either<String, RestServiceAuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Type of authentication used to connect to the REST service.
     */
    @JvmName("bukgtflwamukonbm")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RestServiceAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Type of authentication used to connect to the REST service.
     */
    @JvmName("aqscgcvthpwgcgfx")
    public fun authenticationType(`value`: RestServiceAuthenticationType) {
        val toBeMapped = Either.ofRight<String, RestServiceAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("pxsixtqinwuokhbt")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The client ID associated with your application. Type: string (or Expression with resultType string).
     */
    @JvmName("cxmpglfihajmfoow")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret associated with your application.
     */
    @JvmName("dopexboolnipebdw")
    public suspend fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret associated with your application.
     */
    @JvmName("dyhdlliknieobnxx")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret associated with your application.
     */
    @JvmName("xypnaiskhvnrblaw")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("uevfpjfkouplmhvl")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("upnfytlfaiwegccb")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("bpnasrachxfkcojb")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("hqalxxycxqkwwdnp")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bmrroepopxywawmd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("dmjqkqhdoesmjgkv")
    public suspend fun enableServerCertificateValidation(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableServerCertificateValidation = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ynvqxouuejcjknbw")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("mjtddwdqxokhraxk")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("txkwmefmtpwtgxek")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("xplxlyqpfkbjldlh")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password used in Basic authentication type.
     */
    @JvmName("yvpffrkrjxoicaxp")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password used in Basic authentication type.
     */
    @JvmName("kwgkhhpepmwqslbj")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password used in Basic authentication type.
     */
    @JvmName("ocjynrlohaiwhomj")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
     */
    @JvmName("ecarluwwbyxkfntm")
    public suspend fun resource(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with resultType string).
     */
    @JvmName("lvvvfdgtfxptapug")
    public suspend fun scope(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType string).
     */
    @JvmName("pesprvjrawxnfgon")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The application's key used in AadServicePrincipal authentication type.
     */
    @JvmName("hydjnhmqonvmglmd")
    public suspend fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The application's key used in AadServicePrincipal authentication type.
     */
    @JvmName("wvlotswixckqgfud")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The application's key used in AadServicePrincipal authentication type.
     */
    @JvmName("aiyrmmpcrojjqcus")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides. Type: string (or Expression with resultType string).
     */
    @JvmName("mumuuktkasysvtgr")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
     */
    @JvmName("ibosdpypdjjsnbkt")
    public suspend fun tokenEndpoint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'RestService'.
     */
    @JvmName("wswoilwydrqsndtg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The base URL of the REST service. Type: string (or Expression with resultType string).
     */
    @JvmName("tkyqrnmxeeteilcu")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The user name used in Basic authentication type. Type: string (or Expression with resultType string).
     */
    @JvmName("jcylyyfpwqqpgyvp")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): RestServiceLinkedServiceArgs = RestServiceLinkedServiceArgs(
        aadResourceId = aadResourceId,
        annotations = annotations,
        authHeaders = authHeaders,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        azureCloudType = azureCloudType,
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        credential = credential,
        description = description,
        enableServerCertificateValidation = enableServerCertificateValidation,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        resource = resource,
        scope = scope,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        tokenEndpoint = tokenEndpoint,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userName = userName,
    )
}
