@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISExecutionCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SSIS package execution credential.
 * @property domain Domain for windows authentication. Type: string (or Expression with resultType string).
 * @property password Password for windows authentication.
 * @property userName UseName for windows authentication. Type: string (or Expression with resultType string).
 */
public data class SSISExecutionCredentialArgs(
    public val domain: Output<Any>,
    public val password: Output<SecureStringArgs>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISExecutionCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISExecutionCredentialArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISExecutionCredentialArgs.builder()
            .domain(domain.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSISExecutionCredentialArgs].
 */
@PulumiTagMarker
public class SSISExecutionCredentialArgsBuilder internal constructor() {
    private var domain: Output<Any>? = null

    private var password: Output<SecureStringArgs>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("cjeqttctyegfimmh")
    public suspend fun domain(`value`: Output<Any>) {
        this.domain = value
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("sbdurwlodjdxvqln")
    public suspend fun password(`value`: Output<SecureStringArgs>) {
        this.password = value
    }

    /**
     * @param value UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("jaoqddmmslyjqpme")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("gsyserbppywahjxj")
    public suspend fun domain(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Password for windows authentication.
     */
    @JvmName("ubiseefeivclxeam")
    public suspend fun password(`value`: SecureStringArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument Password for windows authentication.
     */
    @JvmName("vlntitltuxumendy")
    public suspend fun password(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("pyxcbnwugtdpxyan")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SSISExecutionCredentialArgs = SSISExecutionCredentialArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        password = password ?: throw PulumiNullFieldException("password"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
