@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISPropertyOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSIS property override.
 * @property isSensitive Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
 * @property value SSIS package property override value. Type: string (or Expression with resultType string).
 */
public data class SSISPropertyOverrideArgs(
    public val isSensitive: Output<Boolean>? = null,
    public val `value`: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISPropertyOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISPropertyOverrideArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISPropertyOverrideArgs.builder()
            .isSensitive(isSensitive?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSISPropertyOverrideArgs].
 */
@PulumiTagMarker
public class SSISPropertyOverrideArgsBuilder internal constructor() {
    private var isSensitive: Output<Boolean>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
     */
    @JvmName("mlhhtqxvwvosqxmh")
    public suspend fun isSensitive(`value`: Output<Boolean>) {
        this.isSensitive = value
    }

    /**
     * @param value SSIS package property override value. Type: string (or Expression with resultType string).
     */
    @JvmName("wmidmyamxkacevam")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
     */
    @JvmName("rbijkkheioacybpm")
    public suspend fun isSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSensitive = mapped
    }

    /**
     * @param value SSIS package property override value. Type: string (or Expression with resultType string).
     */
    @JvmName("dataoubiyfwvngkf")
    public suspend fun `value`(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SSISPropertyOverrideArgs = SSISPropertyOverrideArgs(
        isSensitive = isSensitive,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
