@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapTableSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity source for SAP Table source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property batchSize Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer).
 * @property customRfcReadTableFunctionModule Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionOption The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth", "PartitionOnCalendarDate", "PartitionOnTime".
 * @property partitionSettings The settings that will be leveraged for SAP table source partitioning.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property rfcTableFields The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string).
 * @property rfcTableOptions The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string).
 * @property rowCount The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
 * @property rowSkips The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
 * @property sapDataColumnDelimiter The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'SapTableSource'.
 */
public data class SapTableSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val batchSize: Output<Any>? = null,
    public val customRfcReadTableFunctionModule: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val partitionOption: Output<Any>? = null,
    public val partitionSettings: Output<SapTablePartitionSettingsArgs>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val rfcTableFields: Output<Any>? = null,
    public val rfcTableOptions: Output<Any>? = null,
    public val rowCount: Output<Any>? = null,
    public val rowSkips: Output<Any>? = null,
    public val sapDataColumnDelimiter: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapTableSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapTableSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.SapTableSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .customRfcReadTableFunctionModule(customRfcReadTableFunctionModule?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .partitionOption(partitionOption?.applyValue({ args0 -> args0 }))
            .partitionSettings(partitionSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .rfcTableFields(rfcTableFields?.applyValue({ args0 -> args0 }))
            .rfcTableOptions(rfcTableOptions?.applyValue({ args0 -> args0 }))
            .rowCount(rowCount?.applyValue({ args0 -> args0 }))
            .rowSkips(rowSkips?.applyValue({ args0 -> args0 }))
            .sapDataColumnDelimiter(sapDataColumnDelimiter?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapTableSourceArgs].
 */
@PulumiTagMarker
public class SapTableSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var batchSize: Output<Any>? = null

    private var customRfcReadTableFunctionModule: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var partitionOption: Output<Any>? = null

    private var partitionSettings: Output<SapTablePartitionSettingsArgs>? = null

    private var queryTimeout: Output<Any>? = null

    private var rfcTableFields: Output<Any>? = null

    private var rfcTableOptions: Output<Any>? = null

    private var rowCount: Output<Any>? = null

    private var rowSkips: Output<Any>? = null

    private var sapDataColumnDelimiter: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("njaubxeqiannsgwl")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer).
     */
    @JvmName("thxwuqeytwlpdbwq")
    public suspend fun batchSize(`value`: Output<Any>) {
        this.batchSize = value
    }

    /**
     * @param value Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
     */
    @JvmName("ahwurnvsikffqasf")
    public suspend fun customRfcReadTableFunctionModule(`value`: Output<Any>) {
        this.customRfcReadTableFunctionModule = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qosbcyboqhkemvtt")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kdgtcavibsbsgtkf")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth", "PartitionOnCalendarDate", "PartitionOnTime".
     */
    @JvmName("ttaajpvbvhwapfxj")
    public suspend fun partitionOption(`value`: Output<Any>) {
        this.partitionOption = value
    }

    /**
     * @param value The settings that will be leveraged for SAP table source partitioning.
     */
    @JvmName("mxcejtvlhvdcoxom")
    public suspend fun partitionSettings(`value`: Output<SapTablePartitionSettingsArgs>) {
        this.partitionSettings = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("logjavyhmwmtoqyw")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string).
     */
    @JvmName("fiwkbnrkyvvunkam")
    public suspend fun rfcTableFields(`value`: Output<Any>) {
        this.rfcTableFields = value
    }

    /**
     * @param value The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string).
     */
    @JvmName("vnfwxscbaqpkgrro")
    public suspend fun rfcTableOptions(`value`: Output<Any>) {
        this.rfcTableOptions = value
    }

    /**
     * @param value The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
     */
    @JvmName("wcnqkuryxepxbqfa")
    public suspend fun rowCount(`value`: Output<Any>) {
        this.rowCount = value
    }

    /**
     * @param value The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
     */
    @JvmName("xqplntjlpvnvrnrc")
    public suspend fun rowSkips(`value`: Output<Any>) {
        this.rowSkips = value
    }

    /**
     * @param value The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     */
    @JvmName("ermueeroilwnqvlv")
    public suspend fun sapDataColumnDelimiter(`value`: Output<Any>) {
        this.sapDataColumnDelimiter = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ijeodlywyroulcux")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ogcrenoyeuhnaytf")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapTableSource'.
     */
    @JvmName("nsonbacafgckupye")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("uqbexlylhgytdsjb")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer).
     */
    @JvmName("xaqkenjaurmiuttg")
    public suspend fun batchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
     */
    @JvmName("soibgjrfynewtagx")
    public suspend fun customRfcReadTableFunctionModule(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRfcReadTableFunctionModule = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("plhomtwigsqtgwuq")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bbwdkohkbeutiifj")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth", "PartitionOnCalendarDate", "PartitionOnTime".
     */
    @JvmName("uapjaxbsdjocildh")
    public suspend fun partitionOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionOption = mapped
    }

    /**
     * @param value The settings that will be leveraged for SAP table source partitioning.
     */
    @JvmName("bcshluyspuvpovmq")
    public suspend fun partitionSettings(`value`: SapTablePartitionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionSettings = mapped
    }

    /**
     * @param argument The settings that will be leveraged for SAP table source partitioning.
     */
    @JvmName("fucyiqraxlkwlisf")
    public suspend fun partitionSettings(argument: suspend SapTablePartitionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SapTablePartitionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionSettings = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("jupsaburwkrofypo")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string).
     */
    @JvmName("wpwpoaiqfkgffevs")
    public suspend fun rfcTableFields(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rfcTableFields = mapped
    }

    /**
     * @param value The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string).
     */
    @JvmName("yefeckylhkkfeaer")
    public suspend fun rfcTableOptions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rfcTableOptions = mapped
    }

    /**
     * @param value The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
     */
    @JvmName("eyhrnryvwpwjecim")
    public suspend fun rowCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowCount = mapped
    }

    /**
     * @param value The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fyylmbnditrwajqr")
    public suspend fun rowSkips(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowSkips = mapped
    }

    /**
     * @param value The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     */
    @JvmName("txdfiuhdcmfmmtwr")
    public suspend fun sapDataColumnDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapDataColumnDelimiter = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bbapcldldpdynovm")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("eslsxkudkxxtbrjv")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapTableSource'.
     */
    @JvmName("rhellvuvkkhvmwid")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SapTableSourceArgs = SapTableSourceArgs(
        additionalColumns = additionalColumns,
        batchSize = batchSize,
        customRfcReadTableFunctionModule = customRfcReadTableFunctionModule,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        partitionOption = partitionOption,
        partitionSettings = partitionSettings,
        queryTimeout = queryTimeout,
        rfcTableFields = rfcTableFields,
        rfcTableOptions = rfcTableOptions,
        rowCount = rowCount,
        rowSkips = rowSkips,
        sapDataColumnDelimiter = sapDataColumnDelimiter,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
