@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScriptActivityParameterArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ScriptActivityParameterDirection
import com.pulumi.azurenative.datafactory.kotlin.enums.ScriptActivityParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters of a script block.
 * @property direction The direction of the parameter.
 * @property name The name of the parameter. Type: string (or Expression with resultType string).
 * @property size The size of the output direction parameter.
 * @property type The type of the parameter.
 * @property value The value of the parameter. Type: string (or Expression with resultType string).
 */
public data class ScriptActivityParameterArgs(
    public val direction: Output<Either<String, ScriptActivityParameterDirection>>? = null,
    public val name: Output<Any>? = null,
    public val size: Output<Int>? = null,
    public val type: Output<Either<String, ScriptActivityParameterType>>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScriptActivityParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ScriptActivityParameterArgs =
        com.pulumi.azurenative.datafactory.inputs.ScriptActivityParameterArgs.builder()
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptActivityParameterArgs].
 */
@PulumiTagMarker
public class ScriptActivityParameterArgsBuilder internal constructor() {
    private var direction: Output<Either<String, ScriptActivityParameterDirection>>? = null

    private var name: Output<Any>? = null

    private var size: Output<Int>? = null

    private var type: Output<Either<String, ScriptActivityParameterType>>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value The direction of the parameter.
     */
    @JvmName("ycyvdckykrwysjqm")
    public suspend fun direction(`value`: Output<Either<String, ScriptActivityParameterDirection>>) {
        this.direction = value
    }

    /**
     * @param value The name of the parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("qfotifwddhcfmomy")
    public suspend fun name(`value`: Output<Any>) {
        this.name = value
    }

    /**
     * @param value The size of the output direction parameter.
     */
    @JvmName("nwbwpxxrdgodlted")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The type of the parameter.
     */
    @JvmName("guudvinocvhpotfr")
    public suspend fun type(`value`: Output<Either<String, ScriptActivityParameterType>>) {
        this.type = value
    }

    /**
     * @param value The value of the parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("ornyyminwjmmgiex")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value The direction of the parameter.
     */
    @JvmName("mrksmeqqcdjaoshd")
    public suspend fun direction(`value`: Either<String, ScriptActivityParameterDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the parameter.
     */
    @JvmName("rclkujcelmehdjxs")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScriptActivityParameterDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the parameter.
     */
    @JvmName("yyyvrmtisuvvtvrf")
    public fun direction(`value`: ScriptActivityParameterDirection) {
        val toBeMapped = Either.ofRight<String, ScriptActivityParameterDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The name of the parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("ecidvqhfbdapbubb")
    public suspend fun name(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The size of the output direction parameter.
     */
    @JvmName("liyvyqnpqkcqwhnu")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The type of the parameter.
     */
    @JvmName("uwlhrrhhcrvgxguh")
    public suspend fun type(`value`: Either<String, ScriptActivityParameterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the parameter.
     */
    @JvmName("tfphljjllecqitay")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScriptActivityParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the parameter.
     */
    @JvmName("yulgesckvtniqwwj")
    public fun type(`value`: ScriptActivityParameterType) {
        val toBeMapped = Either.ofRight<String, ScriptActivityParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the parameter. Type: string (or Expression with resultType string).
     */
    @JvmName("hmqkqcqbhtkqvmeq")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ScriptActivityParameterArgs = ScriptActivityParameterArgs(
        direction = direction,
        name = name,
        size = size,
        type = type,
        `value` = `value`,
    )
}
