@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Script block of scripts.
 * @property parameters Array of script parameters. Type: array.
 * @property text The query text. Type: string (or Expression with resultType string).
 * @property type The type of the query. Please refer to the ScriptType for valid options. Type: string (or Expression with resultType string).
 */
public data class ScriptActivityScriptBlockArgs(
    public val parameters: Output<List<ScriptActivityParameterArgs>>? = null,
    public val text: Output<Any>,
    public val type: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs =
        com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .text(text.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptActivityScriptBlockArgs].
 */
@PulumiTagMarker
public class ScriptActivityScriptBlockArgsBuilder internal constructor() {
    private var parameters: Output<List<ScriptActivityParameterArgs>>? = null

    private var text: Output<Any>? = null

    private var type: Output<Any>? = null

    /**
     * @param value Array of script parameters. Type: array.
     */
    @JvmName("pxbwnwikjfthodky")
    public suspend fun parameters(`value`: Output<List<ScriptActivityParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("jvtkocveorvdhjpr")
    public suspend fun parameters(vararg values: Output<ScriptActivityParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Array of script parameters. Type: array.
     */
    @JvmName("qqvckitvlbxcxsdm")
    public suspend fun parameters(values: List<Output<ScriptActivityParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The query text. Type: string (or Expression with resultType string).
     */
    @JvmName("ybphjvjgbuhiraiu")
    public suspend fun text(`value`: Output<Any>) {
        this.text = value
    }

    /**
     * @param value The type of the query. Please refer to the ScriptType for valid options. Type: string (or Expression with resultType string).
     */
    @JvmName("jlwslnufggihvuan")
    public suspend fun type(`value`: Output<Any>) {
        this.type = value
    }

    /**
     * @param value Array of script parameters. Type: array.
     */
    @JvmName("wtqmjwwxuqocclpi")
    public suspend fun parameters(`value`: List<ScriptActivityParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("lajcspdhpcqewxbp")
    public suspend fun parameters(argument: List<suspend ScriptActivityParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScriptActivityParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("xmjbarbbkdhhousv")
    public suspend fun parameters(vararg argument: suspend ScriptActivityParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScriptActivityParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("jkwmilsqyxryhkdl")
    public suspend fun parameters(argument: suspend ScriptActivityParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScriptActivityParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Array of script parameters. Type: array.
     */
    @JvmName("kebctnceiygdhfvl")
    public suspend fun parameters(vararg values: ScriptActivityParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The query text. Type: string (or Expression with resultType string).
     */
    @JvmName("hbhbfrlwsxyfuwjp")
    public suspend fun text(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param value The type of the query. Please refer to the ScriptType for valid options. Type: string (or Expression with resultType string).
     */
    @JvmName("rdeywyrfcoprexmd")
    public suspend fun type(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScriptActivityScriptBlockArgs = ScriptActivityScriptBlockArgs(
        parameters = parameters,
        text = text ?: throw PulumiNullFieldException("text"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
