@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Sftp write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property metadata Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
 * @property operationTimeout Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
 * @property type The write setting type.
 * Expected value is 'SftpWriteSettings'.
 * @property useTempFileRename Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
 */
public data class SftpWriteSettingsArgs(
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val metadata: Output<List<MetadataItemArgs>>? = null,
    public val operationTimeout: Output<Any>? = null,
    public val type: Output<String>,
    public val useTempFileRename: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs.builder()
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .operationTimeout(operationTimeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useTempFileRename(useTempFileRename?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SftpWriteSettingsArgs].
 */
@PulumiTagMarker
public class SftpWriteSettingsArgsBuilder internal constructor() {
    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var metadata: Output<List<MetadataItemArgs>>? = null

    private var operationTimeout: Output<Any>? = null

    private var type: Output<String>? = null

    private var useTempFileRename: Output<Any>? = null

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("btlkxirnhnsshtck")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lmewdiitbgfcibwd")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hfybwhsmthxifuen")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("mvkefuantkxjyimx")
    public suspend fun metadata(`value`: Output<List<MetadataItemArgs>>) {
        this.metadata = value
    }

    @JvmName("clcddxmsknoonwen")
    public suspend fun metadata(vararg values: Output<MetadataItemArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("htatbostnvwiiwrl")
    public suspend fun metadata(values: List<Output<MetadataItemArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
     */
    @JvmName("sbjpgsjqaflxhvva")
    public suspend fun operationTimeout(`value`: Output<Any>) {
        this.operationTimeout = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'SftpWriteSettings'.
     */
    @JvmName("ibubbvailjtoamuf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qnlnmuycrrfdoodv")
    public suspend fun useTempFileRename(`value`: Output<Any>) {
        this.useTempFileRename = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("alwkquyfjekefvrk")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kpfbdtdanphddmaq")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vdwlicbksdydmmho")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("xywrbtbkddejperd")
    public suspend fun metadata(`value`: List<MetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("vfhqppayvwdbyebr")
    public suspend fun metadata(argument: List<suspend MetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("qxlurvybaqdgnbwr")
    public suspend fun metadata(vararg argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("gsuywcipxshpcftq")
    public suspend fun metadata(argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("ldrfkubiggcljmpw")
    public suspend fun metadata(vararg values: MetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
     */
    @JvmName("jlsywsevcmnfqdfd")
    public suspend fun operationTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationTimeout = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'SftpWriteSettings'.
     */
    @JvmName("mqwhmjpqikapmlur")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qpjfxwkgdvyknpnn")
    public suspend fun useTempFileRename(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTempFileRename = mapped
    }

    internal fun build(): SftpWriteSettingsArgs = SftpWriteSettingsArgs(
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        metadata = metadata,
        operationTimeout = operationTimeout,
        type = type ?: throw PulumiNullFieldException("type"),
        useTempFileRename = useTempFileRename,
    )
}
