@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlAlwaysEncryptedPropertiesArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SqlAlwaysEncryptedAkvAuthType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Sql always encrypted properties.
 * @property alwaysEncryptedAkvAuthType Sql always encrypted AKV authentication type. Type: string.
 * @property credential The credential reference containing authentication information.
 * @property servicePrincipalId The client ID of the application in Azure Active Directory used for Azure Key Vault authentication. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Azure Key Vault.
 */
public data class SqlAlwaysEncryptedPropertiesArgs(
    public val alwaysEncryptedAkvAuthType: Output<Either<String, SqlAlwaysEncryptedAkvAuthType>>,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlAlwaysEncryptedPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlAlwaysEncryptedPropertiesArgs = com.pulumi.azurenative.datafactory.inputs.SqlAlwaysEncryptedPropertiesArgs.builder()
        .alwaysEncryptedAkvAuthType(
            alwaysEncryptedAkvAuthType.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
        .servicePrincipalKey(
            servicePrincipalKey?.applyValue({ args0 ->
                args0.transform({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [SqlAlwaysEncryptedPropertiesArgs].
 */
@PulumiTagMarker
public class SqlAlwaysEncryptedPropertiesArgsBuilder internal constructor() {
    private var alwaysEncryptedAkvAuthType: Output<Either<String, SqlAlwaysEncryptedAkvAuthType>>? =
        null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    /**
     * @param value Sql always encrypted AKV authentication type. Type: string.
     */
    @JvmName("cehbwmiuhskkacon")
    public suspend fun alwaysEncryptedAkvAuthType(`value`: Output<Either<String, SqlAlwaysEncryptedAkvAuthType>>) {
        this.alwaysEncryptedAkvAuthType = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("suhsofreledfveka")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Azure Key Vault authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("wnrmewlqfmgtpxww")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure Key Vault.
     */
    @JvmName("gxpwtnbudlkiucny")
    public suspend fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value Sql always encrypted AKV authentication type. Type: string.
     */
    @JvmName("fnqljosttuwndxak")
    public suspend fun alwaysEncryptedAkvAuthType(`value`: Either<String, SqlAlwaysEncryptedAkvAuthType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysEncryptedAkvAuthType = mapped
    }

    /**
     * @param value Sql always encrypted AKV authentication type. Type: string.
     */
    @JvmName("vhtlbrehhehhwmvx")
    public fun alwaysEncryptedAkvAuthType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlAlwaysEncryptedAkvAuthType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysEncryptedAkvAuthType = mapped
    }

    /**
     * @param value Sql always encrypted AKV authentication type. Type: string.
     */
    @JvmName("lhsywuiubfvxnkgb")
    public fun alwaysEncryptedAkvAuthType(`value`: SqlAlwaysEncryptedAkvAuthType) {
        val toBeMapped = Either.ofRight<String, SqlAlwaysEncryptedAkvAuthType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysEncryptedAkvAuthType = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("kqkqapkiijeopsna")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("mgyqeoxajnskokbd")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Azure Key Vault authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("ttjxgexjrqijpggg")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure Key Vault.
     */
    @JvmName("vrunxfownwwicoem")
    public suspend fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure Key Vault.
     */
    @JvmName("dfajaavjvqfgwilv")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure Key Vault.
     */
    @JvmName("yadxiflqjfqtukul")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    internal fun build(): SqlAlwaysEncryptedPropertiesArgs = SqlAlwaysEncryptedPropertiesArgs(
        alwaysEncryptedAkvAuthType = alwaysEncryptedAkvAuthType ?: throw
            PulumiNullFieldException("alwaysEncryptedAkvAuthType"),
        credential = credential,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
    )
}
