@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlDWSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity SQL Data Warehouse sink.
 * @property allowCopyCommand Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
 * @property allowPolyBase Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean).
 * @property copyCommandSettings Specifies Copy Command related settings when allowCopyCommand is true.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property polyBaseSettings Specifies PolyBase-related settings when allowPolyBase is true.
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlWriterUseTableLock Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
 * @property tableOption The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
 * @property type Copy sink type.
 * Expected value is 'SqlDWSink'.
 * @property upsertSettings SQL DW upsert settings.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
 */
public data class SqlDWSinkArgs(
    public val allowCopyCommand: Output<Any>? = null,
    public val allowPolyBase: Output<Any>? = null,
    public val copyCommandSettings: Output<DWCopyCommandSettingsArgs>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val polyBaseSettings: Output<PolybaseSettingsArgs>? = null,
    public val preCopyScript: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val sqlWriterUseTableLock: Output<Any>? = null,
    public val tableOption: Output<Any>? = null,
    public val type: Output<String>,
    public val upsertSettings: Output<SqlDWUpsertSettingsArgs>? = null,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlDWSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlDWSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlDWSinkArgs.builder()
            .allowCopyCommand(allowCopyCommand?.applyValue({ args0 -> args0 }))
            .allowPolyBase(allowPolyBase?.applyValue({ args0 -> args0 }))
            .copyCommandSettings(
                copyCommandSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .polyBaseSettings(polyBaseSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preCopyScript(preCopyScript?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .sqlWriterUseTableLock(sqlWriterUseTableLock?.applyValue({ args0 -> args0 }))
            .tableOption(tableOption?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .upsertSettings(upsertSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(writeBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlDWSinkArgs].
 */
@PulumiTagMarker
public class SqlDWSinkArgsBuilder internal constructor() {
    private var allowCopyCommand: Output<Any>? = null

    private var allowPolyBase: Output<Any>? = null

    private var copyCommandSettings: Output<DWCopyCommandSettingsArgs>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var polyBaseSettings: Output<PolybaseSettingsArgs>? = null

    private var preCopyScript: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var sqlWriterUseTableLock: Output<Any>? = null

    private var tableOption: Output<Any>? = null

    private var type: Output<String>? = null

    private var upsertSettings: Output<SqlDWUpsertSettingsArgs>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Any>? = null

    /**
     * @param value Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xijwkdoqlkojhkgl")
    public suspend fun allowCopyCommand(`value`: Output<Any>) {
        this.allowCopyCommand = value
    }

    /**
     * @param value Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nxmjwxaiowwcacjt")
    public suspend fun allowPolyBase(`value`: Output<Any>) {
        this.allowPolyBase = value
    }

    /**
     * @param value Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("wdpvppqvvkfvlknm")
    public suspend fun copyCommandSettings(`value`: Output<DWCopyCommandSettingsArgs>) {
        this.copyCommandSettings = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tnkbhbdaqtbynprx")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mttddlspdbbyohba")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specifies PolyBase-related settings when allowPolyBase is true.
     */
    @JvmName("trtrodteltitejdi")
    public suspend fun polyBaseSettings(`value`: Output<PolybaseSettingsArgs>) {
        this.polyBaseSettings = value
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("lhugvgyrliieqahq")
    public suspend fun preCopyScript(`value`: Output<Any>) {
        this.preCopyScript = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rrxybivekfrbkydr")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("tojwrkxqdocqhglb")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("orbpdyrjesakotqo")
    public suspend fun sqlWriterUseTableLock(`value`: Output<Any>) {
        this.sqlWriterUseTableLock = value
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("bnbjoiedwqqceahg")
    public suspend fun tableOption(`value`: Output<Any>) {
        this.tableOption = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SqlDWSink'.
     */
    @JvmName("hqugexfdbdkjayxr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value SQL DW upsert settings.
     */
    @JvmName("mtydibygishpjelv")
    public suspend fun upsertSettings(`value`: Output<SqlDWUpsertSettingsArgs>) {
        this.upsertSettings = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("pcqaynjymlodjdlp")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("mpuunqqlukgwdtrs")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
     */
    @JvmName("apdyaykkxvxjeehu")
    public suspend fun writeBehavior(`value`: Output<Any>) {
        this.writeBehavior = value
    }

    /**
     * @param value Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("libqagukjkycwull")
    public suspend fun allowCopyCommand(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCopyCommand = mapped
    }

    /**
     * @param value Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bxrkgutaoiffpfym")
    public suspend fun allowPolyBase(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowPolyBase = mapped
    }

    /**
     * @param value Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("mmqdfbhnjrvtddyo")
    public suspend fun copyCommandSettings(`value`: DWCopyCommandSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyCommandSettings = mapped
    }

    /**
     * @param argument Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("ofnajukcnosekorv")
    public suspend fun copyCommandSettings(argument: suspend DWCopyCommandSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DWCopyCommandSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.copyCommandSettings = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ctnpssvlckekitjh")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rxaclkwgbtgxqkdx")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specifies PolyBase-related settings when allowPolyBase is true.
     */
    @JvmName("naaqhilwatftcpna")
    public suspend fun polyBaseSettings(`value`: PolybaseSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.polyBaseSettings = mapped
    }

    /**
     * @param argument Specifies PolyBase-related settings when allowPolyBase is true.
     */
    @JvmName("vgptgcxxgqhmtacq")
    public suspend fun polyBaseSettings(argument: suspend PolybaseSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PolybaseSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.polyBaseSettings = mapped
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("oiurcfixxvvygumx")
    public suspend fun preCopyScript(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preCopyScript = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("muoafhykdvdarojm")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("jaftbepbqqqksdcm")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("yoqwjwboudxtuffn")
    public suspend fun sqlWriterUseTableLock(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWriterUseTableLock = mapped
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("cilwhgfxwippfqii")
    public suspend fun tableOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableOption = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SqlDWSink'.
     */
    @JvmName("mutuoxcmuucginfo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value SQL DW upsert settings.
     */
    @JvmName("ipbgylekhcmjfgdu")
    public suspend fun upsertSettings(`value`: SqlDWUpsertSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upsertSettings = mapped
    }

    /**
     * @param argument SQL DW upsert settings.
     */
    @JvmName("tttqwgvuuomutind")
    public suspend fun upsertSettings(argument: suspend SqlDWUpsertSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlDWUpsertSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upsertSettings = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("msbnatghtpvylbtv")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("pvuobptvtylhbpeq")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
     */
    @JvmName("cmokdngwwvdomkot")
    public suspend fun writeBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): SqlDWSinkArgs = SqlDWSinkArgs(
        allowCopyCommand = allowCopyCommand,
        allowPolyBase = allowPolyBase,
        copyCommandSettings = copyCommandSettings,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        polyBaseSettings = polyBaseSettings,
        preCopyScript = preCopyScript,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        sqlWriterUseTableLock = sqlWriterUseTableLock,
        tableOption = tableOption,
        type = type ?: throw PulumiNullFieldException("type"),
        upsertSettings = upsertSettings,
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
