@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlServerSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity SQL server source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property isolationLevel Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionOption The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange". Type: string (or Expression with resultType string).
 * @property partitionSettings The settings that will be leveraged for Sql source partitioning.
 * @property produceAdditionalTypes Which additional types to produce.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlReaderQuery SQL reader query. Type: string (or Expression with resultType string).
 * @property sqlReaderStoredProcedureName Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
 * @property storedProcedureParameters Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
 * @property type Copy source type.
 * Expected value is 'SqlServerSource'.
 */
public data class SqlServerSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val isolationLevel: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val partitionOption: Output<Any>? = null,
    public val partitionSettings: Output<SqlPartitionSettingsArgs>? = null,
    public val produceAdditionalTypes: Output<Any>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val sqlReaderQuery: Output<Any>? = null,
    public val sqlReaderStoredProcedureName: Output<Any>? = null,
    public val storedProcedureParameters: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlServerSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlServerSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlServerSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .isolationLevel(isolationLevel?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .partitionOption(partitionOption?.applyValue({ args0 -> args0 }))
            .partitionSettings(partitionSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .produceAdditionalTypes(produceAdditionalTypes?.applyValue({ args0 -> args0 }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .sqlReaderQuery(sqlReaderQuery?.applyValue({ args0 -> args0 }))
            .sqlReaderStoredProcedureName(sqlReaderStoredProcedureName?.applyValue({ args0 -> args0 }))
            .storedProcedureParameters(storedProcedureParameters?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlServerSourceArgs].
 */
@PulumiTagMarker
public class SqlServerSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var isolationLevel: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var partitionOption: Output<Any>? = null

    private var partitionSettings: Output<SqlPartitionSettingsArgs>? = null

    private var produceAdditionalTypes: Output<Any>? = null

    private var queryTimeout: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var sqlReaderQuery: Output<Any>? = null

    private var sqlReaderStoredProcedureName: Output<Any>? = null

    private var storedProcedureParameters: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("krvwhrwyqfcsvlnn")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vculknjnqrtgqphh")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
     */
    @JvmName("pjpyuenmagnbsysq")
    public suspend fun isolationLevel(`value`: Output<Any>) {
        this.isolationLevel = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("pdmglfoaiuxihvqs")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange". Type: string (or Expression with resultType string).
     */
    @JvmName("dtofcwlheombcses")
    public suspend fun partitionOption(`value`: Output<Any>) {
        this.partitionOption = value
    }

    /**
     * @param value The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("wxvpgaoqhbgggiyq")
    public suspend fun partitionSettings(`value`: Output<SqlPartitionSettingsArgs>) {
        this.partitionSettings = value
    }

    /**
     * @param value Which additional types to produce.
     */
    @JvmName("saejqucmjqqnpmnn")
    public suspend fun produceAdditionalTypes(`value`: Output<Any>) {
        this.produceAdditionalTypes = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("fumvptceqxkeflqr")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ewduvhdrbtahjbdj")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("yphvmanbgxwletyr")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value SQL reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("ockldthwgpybumkl")
    public suspend fun sqlReaderQuery(`value`: Output<Any>) {
        this.sqlReaderQuery = value
    }

    /**
     * @param value Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
     */
    @JvmName("wqhgkgpdgglxqnpf")
    public suspend fun sqlReaderStoredProcedureName(`value`: Output<Any>) {
        this.sqlReaderStoredProcedureName = value
    }

    /**
     * @param value Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
     */
    @JvmName("glmtoyplnmfpugcw")
    public suspend fun storedProcedureParameters(`value`: Output<Any>) {
        this.storedProcedureParameters = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SqlServerSource'.
     */
    @JvmName("yaqnrejxkukoxjqq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("mwpdfkijgrqajlgu")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jcpvdoqvykcfmamg")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
     */
    @JvmName("aoreqyfpbcacyoep")
    public suspend fun isolationLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolationLevel = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jiiaecunvqanedvv")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange". Type: string (or Expression with resultType string).
     */
    @JvmName("ccrlbdqwrabucolw")
    public suspend fun partitionOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionOption = mapped
    }

    /**
     * @param value The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("dlxiebmpcjujrhkl")
    public suspend fun partitionSettings(`value`: SqlPartitionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionSettings = mapped
    }

    /**
     * @param argument The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("ldjfukshqdophhwq")
    public suspend fun partitionSettings(argument: suspend SqlPartitionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlPartitionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionSettings = mapped
    }

    /**
     * @param value Which additional types to produce.
     */
    @JvmName("prtlvqppkqghsdrd")
    public suspend fun produceAdditionalTypes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.produceAdditionalTypes = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("hlggicpafpinisif")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dxdfygcijgrrshaa")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kjaggbijldulmtfb")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value SQL reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("sxmtuwolvgolykqr")
    public suspend fun sqlReaderQuery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlReaderQuery = mapped
    }

    /**
     * @param value Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
     */
    @JvmName("kijearpttlliyvft")
    public suspend fun sqlReaderStoredProcedureName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlReaderStoredProcedureName = mapped
    }

    /**
     * @param value Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
     */
    @JvmName("vljhyekrlnxwdtpf")
    public suspend fun storedProcedureParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedProcedureParameters = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SqlServerSource'.
     */
    @JvmName("rumqceccounwryxk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SqlServerSourceArgs = SqlServerSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        isolationLevel = isolationLevel,
        maxConcurrentConnections = maxConcurrentConnections,
        partitionOption = partitionOption,
        partitionSettings = partitionSettings,
        produceAdditionalTypes = produceAdditionalTypes,
        queryTimeout = queryTimeout,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        sqlReaderQuery = sqlReaderQuery,
        sqlReaderStoredProcedureName = sqlReaderStoredProcedureName,
        storedProcedureParameters = storedProcedureParameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
