@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.StagingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Staging settings.
 * @property enableCompression Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property linkedServiceName Staging linked service reference.
 * @property path The path to storage for storing the interim data. Type: string (or Expression with resultType string).
 */
public data class StagingSettingsArgs(
    public val enableCompression: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val path: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.StagingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.StagingSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.StagingSettingsArgs.builder()
            .enableCompression(enableCompression?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StagingSettingsArgs].
 */
@PulumiTagMarker
public class StagingSettingsArgsBuilder internal constructor() {
    private var enableCompression: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var path: Output<Any>? = null

    /**
     * @param value Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ltlatfbawueufexj")
    public suspend fun enableCompression(`value`: Output<Any>) {
        this.enableCompression = value
    }

    /**
     * @param value Staging linked service reference.
     */
    @JvmName("ttecttrpigekvfoy")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The path to storage for storing the interim data. Type: string (or Expression with resultType string).
     */
    @JvmName("fckdbcpfeueoyngy")
    public suspend fun path(`value`: Output<Any>) {
        this.path = value
    }

    /**
     * @param value Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fbytwuwrccyifvnn")
    public suspend fun enableCompression(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCompression = mapped
    }

    /**
     * @param value Staging linked service reference.
     */
    @JvmName("wctihujvnanlnijg")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Staging linked service reference.
     */
    @JvmName("iaapxxiepcdxpntt")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The path to storage for storing the interim data. Type: string (or Expression with resultType string).
     */
    @JvmName("jyscmjyxysbpkvpg")
    public suspend fun path(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): StagingSettingsArgs = StagingSettingsArgs(
        enableCompression = enableCompression,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        path = path,
    )
}
