@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SwitchCaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Switch cases with have a value and corresponding activities.
 * @property activities List of activities to execute for satisfied case condition.
 * @property value Expected value that satisfies the expression result of the 'on' property.
 */
public data class SwitchCaseArgs(
    public val activities: Output<List<Any>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SwitchCaseArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SwitchCaseArgs =
        com.pulumi.azurenative.datafactory.inputs.SwitchCaseArgs.builder()
            .activities(activities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SwitchCaseArgs].
 */
@PulumiTagMarker
public class SwitchCaseArgsBuilder internal constructor() {
    private var activities: Output<List<Any>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value List of activities to execute for satisfied case condition.
     */
    @JvmName("mwrxwppgycbdqwao")
    public suspend fun activities(`value`: Output<List<Any>>) {
        this.activities = value
    }

    @JvmName("oxdtjvyvptcclbrg")
    public suspend fun activities(vararg values: Output<Any>) {
        this.activities = Output.all(values.asList())
    }

    /**
     * @param values List of activities to execute for satisfied case condition.
     */
    @JvmName("blpgytmyntkjbeip")
    public suspend fun activities(values: List<Output<Any>>) {
        this.activities = Output.all(values)
    }

    /**
     * @param value Expected value that satisfies the expression result of the 'on' property.
     */
    @JvmName("dompgtsoyugmimcf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value List of activities to execute for satisfied case condition.
     */
    @JvmName("olwohtciqqbkpsdg")
    public suspend fun activities(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param values List of activities to execute for satisfied case condition.
     */
    @JvmName("oqxdjbcfjdbvowfx")
    public suspend fun activities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param value Expected value that satisfies the expression result of the 'on' property.
     */
    @JvmName("lwcbjivbcsjrugmq")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SwitchCaseArgs = SwitchCaseArgs(
        activities = activities,
        `value` = `value`,
    )
}
