@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SynapseNotebookActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.ConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Execute Synapse notebook activity.
 * @property conf Spark configuration properties, which will override the 'conf' of the notebook you provide.
 * @property configurationType The type of the spark config.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property driverSize Number of core and memory to be used for driver allocated in the specified Spark pool for the session, which will be used for overriding 'driverCores' and 'driverMemory' of the notebook you provide. Type: string (or Expression with resultType string).
 * @property executorSize Number of core and memory to be used for executors allocated in the specified Spark pool for the session, which will be used for overriding 'executorCores' and 'executorMemory' of the notebook you provide. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property notebook Synapse notebook reference.
 * @property numExecutors Number of executors to launch for this session, which will override the 'numExecutors' of the notebook you provide. Type: integer (or Expression with resultType integer).
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property parameters Notebook parameters.
 * @property policy Activity policy.
 * @property sparkConfig Spark configuration property.
 * @property sparkPool The name of the big data pool which will be used to execute the notebook.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property targetSparkConfiguration The spark configuration of the spark job.
 * @property type Type of activity.
 * Expected value is 'SynapseNotebook'.
 * @property userProperties Activity user properties.
 */
public data class SynapseNotebookActivityArgs(
    public val conf: Output<Any>? = null,
    public val configurationType: Output<Either<String, ConfigurationType>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val driverSize: Output<Any>? = null,
    public val executorSize: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val notebook: Output<SynapseNotebookReferenceArgs>,
    public val numExecutors: Output<Any>? = null,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val parameters: Output<Map<String, NotebookParameterArgs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val sparkConfig: Output<Map<String, Any>>? = null,
    public val sparkPool: Output<BigDataPoolParametrizationReferenceArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val targetSparkConfiguration: Output<SparkConfigurationParametrizationReferenceArgs>? =
        null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SynapseNotebookActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SynapseNotebookActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.SynapseNotebookActivityArgs.builder()
            .conf(conf?.applyValue({ args0 -> args0 }))
            .configurationType(
                configurationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .driverSize(driverSize?.applyValue({ args0 -> args0 }))
            .executorSize(executorSize?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .notebook(notebook.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .numExecutors(numExecutors?.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sparkConfig(
                sparkConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sparkPool(sparkPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetSparkConfiguration(
                targetSparkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SynapseNotebookActivityArgs].
 */
@PulumiTagMarker
public class SynapseNotebookActivityArgsBuilder internal constructor() {
    private var conf: Output<Any>? = null

    private var configurationType: Output<Either<String, ConfigurationType>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var driverSize: Output<Any>? = null

    private var executorSize: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var notebook: Output<SynapseNotebookReferenceArgs>? = null

    private var numExecutors: Output<Any>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var parameters: Output<Map<String, NotebookParameterArgs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var sparkConfig: Output<Map<String, Any>>? = null

    private var sparkPool: Output<BigDataPoolParametrizationReferenceArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var targetSparkConfiguration: Output<SparkConfigurationParametrizationReferenceArgs>? =
        null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Spark configuration properties, which will override the 'conf' of the notebook you provide.
     */
    @JvmName("ylmvcjxngqktdcoq")
    public suspend fun conf(`value`: Output<Any>) {
        this.conf = value
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("ceqhnxhiwfhlxshm")
    public suspend fun configurationType(`value`: Output<Either<String, ConfigurationType>>) {
        this.configurationType = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("suwffyulwsapuvqx")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("qqcydbwpcufkspsf")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("xxqjgvxvpfdryhfq")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("hylpscgipangkvxl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Number of core and memory to be used for driver allocated in the specified Spark pool for the session, which will be used for overriding 'driverCores' and 'driverMemory' of the notebook you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("vdyifwjioirpwsop")
    public suspend fun driverSize(`value`: Output<Any>) {
        this.driverSize = value
    }

    /**
     * @param value Number of core and memory to be used for executors allocated in the specified Spark pool for the session, which will be used for overriding 'executorCores' and 'executorMemory' of the notebook you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("xrqgumygdfcdkcgb")
    public suspend fun executorSize(`value`: Output<Any>) {
        this.executorSize = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("rwbbrehgjjgabnog")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("cjxykoqtxylatjrv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Synapse notebook reference.
     */
    @JvmName("jlxjuuvbvnuphpms")
    public suspend fun notebook(`value`: Output<SynapseNotebookReferenceArgs>) {
        this.notebook = value
    }

    /**
     * @param value Number of executors to launch for this session, which will override the 'numExecutors' of the notebook you provide. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ilfprltjxbjbpuoj")
    public suspend fun numExecutors(`value`: Output<Any>) {
        this.numExecutors = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("pfvfseddgadjvgnw")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Notebook parameters.
     */
    @JvmName("qgfpwdobogmpucyf")
    public suspend fun parameters(`value`: Output<Map<String, NotebookParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("klfnodnwgigtkvsb")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("kbxuceqclprskdik")
    public suspend fun sparkConfig(`value`: Output<Map<String, Any>>) {
        this.sparkConfig = value
    }

    /**
     * @param value The name of the big data pool which will be used to execute the notebook.
     */
    @JvmName("owxdkuttvrcqlncw")
    public suspend fun sparkPool(`value`: Output<BigDataPoolParametrizationReferenceArgs>) {
        this.sparkPool = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("tystdfolcemxcesb")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value The spark configuration of the spark job.
     */
    @JvmName("tjquivcoivqhyxev")
    public suspend fun targetSparkConfiguration(`value`: Output<SparkConfigurationParametrizationReferenceArgs>) {
        this.targetSparkConfiguration = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'SynapseNotebook'.
     */
    @JvmName("poljcbtrkwpqjiie")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("iqbourqhssbccuti")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("jkeutbpktjkullgk")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("gohwwpsdjyolwsqm")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Spark configuration properties, which will override the 'conf' of the notebook you provide.
     */
    @JvmName("ixgkswudlwteujcn")
    public suspend fun conf(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conf = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("kpdnybwpwhupwjtu")
    public suspend fun configurationType(`value`: Either<String, ConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("lwbpqmkccxskedgs")
    public fun configurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("folbqtnraijlwbqj")
    public fun configurationType(`value`: ConfigurationType) {
        val toBeMapped = Either.ofRight<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("lkfvfqanrklmxhho")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("vcwjqswgqtfewpnj")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("kaqetkqygukqkxit")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("ygqqwbtqpqsiyjli")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("amdgjuevbkosptts")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("wguwcvgsaouypncm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Number of core and memory to be used for driver allocated in the specified Spark pool for the session, which will be used for overriding 'driverCores' and 'driverMemory' of the notebook you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("vpwypmxflgofucrp")
    public suspend fun driverSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driverSize = mapped
    }

    /**
     * @param value Number of core and memory to be used for executors allocated in the specified Spark pool for the session, which will be used for overriding 'executorCores' and 'executorMemory' of the notebook you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("nfthvrfxgnkbgnpd")
    public suspend fun executorSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executorSize = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("wqhtqwccrxieappv")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("swvbqedmdvfvufrb")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("bgeiucnslhnrdfkb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Synapse notebook reference.
     */
    @JvmName("hllmntgremhxpjll")
    public suspend fun notebook(`value`: SynapseNotebookReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notebook = mapped
    }

    /**
     * @param argument Synapse notebook reference.
     */
    @JvmName("cdogtcsjpbovkjky")
    public suspend fun notebook(argument: suspend SynapseNotebookReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SynapseNotebookReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notebook = mapped
    }

    /**
     * @param value Number of executors to launch for this session, which will override the 'numExecutors' of the notebook you provide. Type: integer (or Expression with resultType integer).
     */
    @JvmName("oywarylggdusblsn")
    public suspend fun numExecutors(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numExecutors = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("alyfcalehjwywgfj")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("qhkblsvhxbnpoeqn")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("fmcmanbptlpdolnr")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Notebook parameters.
     */
    @JvmName("lncyrcutrmpjavpn")
    public suspend fun parameters(`value`: Map<String, NotebookParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Notebook parameters.
     */
    @JvmName("sprqhjavtevjhuxn")
    public suspend fun parameters(vararg argument: Pair<String, suspend NotebookParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                NotebookParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Notebook parameters.
     */
    @JvmName("rijexdmgsegmrbuu")
    public fun parameters(vararg values: Pair<String, NotebookParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("fhrlwgvjotgkifau")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("hvgacuoolnmbiorj")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("xqkdcgshcjglpmul")
    public suspend fun sparkConfig(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param values Spark configuration property.
     */
    @JvmName("lroegkefpbuefdne")
    public fun sparkConfig(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param value The name of the big data pool which will be used to execute the notebook.
     */
    @JvmName("lfekeljctffiegio")
    public suspend fun sparkPool(`value`: BigDataPoolParametrizationReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkPool = mapped
    }

    /**
     * @param argument The name of the big data pool which will be used to execute the notebook.
     */
    @JvmName("wvklajroutvasevg")
    public suspend fun sparkPool(argument: suspend BigDataPoolParametrizationReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = BigDataPoolParametrizationReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sparkPool = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ooroxvlxujflvkaf")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("bgrviepgerckkwkw")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("bqtnoueydrjykojv")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The spark configuration of the spark job.
     */
    @JvmName("loovixdonckkviay")
    public suspend fun targetSparkConfiguration(`value`: SparkConfigurationParametrizationReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSparkConfiguration = mapped
    }

    /**
     * @param argument The spark configuration of the spark job.
     */
    @JvmName("dimmymkeacnxvbfj")
    public suspend fun targetSparkConfiguration(argument: suspend SparkConfigurationParametrizationReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SparkConfigurationParametrizationReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetSparkConfiguration = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'SynapseNotebook'.
     */
    @JvmName("xtndoavnbcjoeoqp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("yvhebfkbhchmswax")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("pteuodvncdpejrgw")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("mlqexxopsbnlveqf")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("hbqtfkopfkpydvkf")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ybtlcqifxnupatky")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): SynapseNotebookActivityArgs = SynapseNotebookActivityArgs(
        conf = conf,
        configurationType = configurationType,
        dependsOn = dependsOn,
        description = description,
        driverSize = driverSize,
        executorSize = executorSize,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        notebook = notebook ?: throw PulumiNullFieldException("notebook"),
        numExecutors = numExecutors,
        onInactiveMarkAs = onInactiveMarkAs,
        parameters = parameters,
        policy = policy,
        sparkConfig = sparkConfig,
        sparkPool = sparkPool,
        state = state,
        targetSparkConfiguration = targetSparkConfiguration,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
