@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SynapseNotebookReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.NotebookReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Synapse notebook reference type.
 * @property referenceName Reference notebook name. Type: string (or Expression with resultType string).
 * @property type Synapse notebook reference type.
 */
public data class SynapseNotebookReferenceArgs(
    public val referenceName: Output<Any>,
    public val type: Output<Either<String, NotebookReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SynapseNotebookReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SynapseNotebookReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.SynapseNotebookReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SynapseNotebookReferenceArgs].
 */
@PulumiTagMarker
public class SynapseNotebookReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<Any>? = null

    private var type: Output<Either<String, NotebookReferenceType>>? = null

    /**
     * @param value Reference notebook name. Type: string (or Expression with resultType string).
     */
    @JvmName("bmnorgggrqrbvwot")
    public suspend fun referenceName(`value`: Output<Any>) {
        this.referenceName = value
    }

    /**
     * @param value Synapse notebook reference type.
     */
    @JvmName("etjdoqpymvgkjrtk")
    public suspend fun type(`value`: Output<Either<String, NotebookReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference notebook name. Type: string (or Expression with resultType string).
     */
    @JvmName("ukmtffjgyqrlsbwb")
    public suspend fun referenceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Synapse notebook reference type.
     */
    @JvmName("ecercdpvcoxmhsid")
    public suspend fun type(`value`: Either<String, NotebookReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Synapse notebook reference type.
     */
    @JvmName("ixdfuavcmyduymku")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotebookReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Synapse notebook reference type.
     */
    @JvmName("kfmsplsutobewxlm")
    public fun type(`value`: NotebookReferenceType) {
        val toBeMapped = Either.ofRight<String, NotebookReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SynapseNotebookReferenceArgs = SynapseNotebookReferenceArgs(
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
