@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TransformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A data flow transformation.
 * @property dataset Dataset reference.
 * @property description Transformation description.
 * @property flowlet Flowlet Reference
 * @property linkedService Linked service reference.
 * @property name Transformation name.
 */
public data class TransformationArgs(
    public val dataset: Output<DatasetReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val flowlet: Output<DataFlowReferenceArgs>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TransformationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TransformationArgs =
        com.pulumi.azurenative.datafactory.inputs.TransformationArgs.builder()
            .dataset(dataset?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowlet(flowlet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransformationArgs].
 */
@PulumiTagMarker
public class TransformationArgsBuilder internal constructor() {
    private var dataset: Output<DatasetReferenceArgs>? = null

    private var description: Output<String>? = null

    private var flowlet: Output<DataFlowReferenceArgs>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Dataset reference.
     */
    @JvmName("tnuvyagupabuwlxs")
    public suspend fun dataset(`value`: Output<DatasetReferenceArgs>) {
        this.dataset = value
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("wpfnybviiyvrjawy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("nfilftijgpuvkdlf")
    public suspend fun flowlet(`value`: Output<DataFlowReferenceArgs>) {
        this.flowlet = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("ktmbhajjpuhbxobf")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("ephgxapwcrypdtpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Dataset reference.
     */
    @JvmName("tgvnbrfxybqpoimm")
    public suspend fun dataset(`value`: DatasetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Dataset reference.
     */
    @JvmName("ddlplddbutqhgyoa")
    public suspend fun dataset(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("hrwytpuebhqcwmwv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("uyopxrevikvexvqp")
    public suspend fun flowlet(`value`: DataFlowReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowlet = mapped
    }

    /**
     * @param argument Flowlet Reference
     */
    @JvmName("udrrcinogwrotifg")
    public suspend fun flowlet(argument: suspend DataFlowReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flowlet = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("ehsbhsjbuixpfoll")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("kissyuecyowbsxho")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("hkxepnkvvuhgcijm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TransformationArgs = TransformationArgs(
        dataset = dataset,
        description = description,
        flowlet = flowlet,
        linkedService = linkedService,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
