@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TwilioLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Twilio.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property parameters Parameters for linked service.
 * @property password The auth token of Twilio service.
 * @property type Type of linked service.
 * Expected value is 'Twilio'.
 * @property userName The Account SID of Twilio service. Type: string (or Expression with resultType string).
 */
public data class TwilioLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val type: Output<String>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TwilioLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TwilioLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.TwilioLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TwilioLinkedServiceArgs].
 */
@PulumiTagMarker
public class TwilioLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gydqsvkwjnlnqaly")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("nneyktuevjmomcok")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ewjvnotbbcuakrus")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("klrmusfucactcqep")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("fbyhtufeliekxeyt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("extsubaqrjfitveu")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The auth token of Twilio service.
     */
    @JvmName("cwhnjhsrkkjbtvoj")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Twilio'.
     */
    @JvmName("xuvydngfhhmdxnks")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Account SID of Twilio service. Type: string (or Expression with resultType string).
     */
    @JvmName("gwhhmlxyyagwvrga")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("debauclmnibogjhy")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rrsvvnikaeyehjyj")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mapolgfqvkadleyt")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("xtlgulnwksfqxyri")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("dagaiklrlgunsyry")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("poauqwkprtcpvhrj")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("gxnxexhtukxigbre")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("usbxvswriwwylwto")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The auth token of Twilio service.
     */
    @JvmName("tjjsvufqhvywcxlx")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The auth token of Twilio service.
     */
    @JvmName("bvgcrlvcdpqomxnn")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The auth token of Twilio service.
     */
    @JvmName("nwdqgkxyfcwhfclp")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Twilio'.
     */
    @JvmName("adrakgkceaeyefdt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Account SID of Twilio service. Type: string (or Expression with resultType string).
     */
    @JvmName("bydreuxqpnmsgddf")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): TwilioLinkedServiceArgs = TwilioLinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        parameters = parameters,
        password = password ?: throw PulumiNullFieldException("password"),
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
