@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WarehouseSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity Microsoft Fabric Warehouse sink.
 * @property allowCopyCommand Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
 * @property copyCommandSettings Specifies Copy Command related settings when allowCopyCommand is true.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property tableOption The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
 * @property type Copy sink type.
 * Expected value is 'WarehouseSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Write behavior when copying data into azure Microsoft Fabric Data Warehouse. Type: DWWriteBehaviorEnum (or Expression with resultType DWWriteBehaviorEnum)
 */
public data class WarehouseSinkArgs(
    public val allowCopyCommand: Output<Any>? = null,
    public val copyCommandSettings: Output<DWCopyCommandSettingsArgs>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val preCopyScript: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val tableOption: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WarehouseSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WarehouseSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.WarehouseSinkArgs.builder()
            .allowCopyCommand(allowCopyCommand?.applyValue({ args0 -> args0 }))
            .copyCommandSettings(
                copyCommandSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .preCopyScript(preCopyScript?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .tableOption(tableOption?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(writeBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WarehouseSinkArgs].
 */
@PulumiTagMarker
public class WarehouseSinkArgsBuilder internal constructor() {
    private var allowCopyCommand: Output<Any>? = null

    private var copyCommandSettings: Output<DWCopyCommandSettingsArgs>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var preCopyScript: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var tableOption: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Any>? = null

    /**
     * @param value Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("urmolnjlyhcfecwj")
    public suspend fun allowCopyCommand(`value`: Output<Any>) {
        this.allowCopyCommand = value
    }

    /**
     * @param value Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("njfceeuaoulkfbqp")
    public suspend fun copyCommandSettings(`value`: Output<DWCopyCommandSettingsArgs>) {
        this.copyCommandSettings = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("rpvtdajdwcabajbi")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jbjkrqrtxbtkweyy")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("vvgiggwbuslpnaqd")
    public suspend fun preCopyScript(`value`: Output<Any>) {
        this.preCopyScript = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("gxhnmquubvqebvmc")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kkqahcrvgmkkjvwt")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("fonpajdrdxpfbcxh")
    public suspend fun tableOption(`value`: Output<Any>) {
        this.tableOption = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'WarehouseSink'.
     */
    @JvmName("fuhgeblwygivuisy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ermxujrpbsjdkygc")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("hgqmcqmhmyabpshp")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Write behavior when copying data into azure Microsoft Fabric Data Warehouse. Type: DWWriteBehaviorEnum (or Expression with resultType DWWriteBehaviorEnum)
     */
    @JvmName("vyhokwkngjvwwgxd")
    public suspend fun writeBehavior(`value`: Output<Any>) {
        this.writeBehavior = value
    }

    /**
     * @param value Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ygjwkonqgaeaemyq")
    public suspend fun allowCopyCommand(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCopyCommand = mapped
    }

    /**
     * @param value Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("jeietijnywfbvjkm")
    public suspend fun copyCommandSettings(`value`: DWCopyCommandSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyCommandSettings = mapped
    }

    /**
     * @param argument Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JvmName("owhejpbjeaycjite")
    public suspend fun copyCommandSettings(argument: suspend DWCopyCommandSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DWCopyCommandSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.copyCommandSettings = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("itehohpieyxxydxf")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hktsavoemlfrknym")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("ksovtrvubckshlwv")
    public suspend fun preCopyScript(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preCopyScript = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kbvikssrqlvwkcjk")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("uqxifrwvcsmqrcjb")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("ucvimcsrdreacnio")
    public suspend fun tableOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableOption = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'WarehouseSink'.
     */
    @JvmName("eiqrryebbhuqkjxq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("cwqmflrsnypjqjhd")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("sobbxvbepwmurrla")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value Write behavior when copying data into azure Microsoft Fabric Data Warehouse. Type: DWWriteBehaviorEnum (or Expression with resultType DWWriteBehaviorEnum)
     */
    @JvmName("dexuaqjhmovlnxay")
    public suspend fun writeBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): WarehouseSinkArgs = WarehouseSinkArgs(
        allowCopyCommand = allowCopyCommand,
        copyCommandSettings = copyCommandSettings,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        preCopyScript = preCopyScript,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        tableOption = tableOption,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
