@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebActivityAuthenticationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Web activity authentication properties.
 * @property credential The credential reference containing authentication information.
 * @property password Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
 * @property pfx Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
 * @property resource Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string).
 * @property type Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal)
 * @property userTenant TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string).
 * @property username Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string).
 */
public data class WebActivityAuthenticationArgs(
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val pfx: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val resource: Output<Any>? = null,
    public val type: Output<String>? = null,
    public val userTenant: Output<Any>? = null,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebActivityAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebActivityAuthenticationArgs =
        com.pulumi.azurenative.datafactory.inputs.WebActivityAuthenticationArgs.builder()
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .pfx(
                pfx?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resource(resource?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .userTenant(userTenant?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebActivityAuthenticationArgs].
 */
@PulumiTagMarker
public class WebActivityAuthenticationArgsBuilder internal constructor() {
    private var credential: Output<CredentialReferenceArgs>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var pfx: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var resource: Output<Any>? = null

    private var type: Output<String>? = null

    private var userTenant: Output<Any>? = null

    private var username: Output<Any>? = null

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("mfwffkolflbbxttw")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
     */
    @JvmName("nokyclrgiesqllpg")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
     */
    @JvmName("wjdetrklboqtuihn")
    public suspend fun pfx(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.pfx = value
    }

    /**
     * @param value Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("htbgkyndjplcjkmg")
    public suspend fun resource(`value`: Output<Any>) {
        this.resource = value
    }

    /**
     * @param value Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal)
     */
    @JvmName("ubqaqmelqhsbejpa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("rcdbmoiqenyoujbp")
    public suspend fun userTenant(`value`: Output<Any>) {
        this.userTenant = value
    }

    /**
     * @param value Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string).
     */
    @JvmName("mtcnvpstyxttnkup")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("kuavengmfewyneki")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("umvekkthvgwbigtc")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
     */
    @JvmName("uliomjhekxydkots")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
     */
    @JvmName("nnwkgidgjabtynwd")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
     */
    @JvmName("hqcmnsbrbkfvonjt")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
     */
    @JvmName("jasbdyuymrwvuwod")
    public suspend fun pfx(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
     */
    @JvmName("obaicguahhvojwjg")
    public fun pfx(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
     */
    @JvmName("wvldtvitaagldiye")
    public fun pfx(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("jfripcyjnprupfcu")
    public suspend fun resource(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal)
     */
    @JvmName("soelrohpsrmifxdh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("fyjjcolbgqnivkjh")
    public suspend fun userTenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userTenant = mapped
    }

    /**
     * @param value Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string).
     */
    @JvmName("ensncucugoblrbre")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): WebActivityAuthenticationArgs = WebActivityAuthenticationArgs(
        credential = credential,
        password = password,
        pfx = pfx,
        resource = resource,
        type = type,
        userTenant = userTenant,
        username = username,
    )
}
