@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebAnonymousAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A WebLinkedService that uses anonymous authentication to communicate with an HTTP endpoint.
 * @property authenticationType Type of authentication used to connect to the web table source.
 * Expected value is 'Anonymous'.
 * @property url The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
 */
public data class WebAnonymousAuthenticationArgs(
    public val authenticationType: Output<String>,
    public val url: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebAnonymousAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebAnonymousAuthenticationArgs =
        com.pulumi.azurenative.datafactory.inputs.WebAnonymousAuthenticationArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAnonymousAuthenticationArgs].
 */
@PulumiTagMarker
public class WebAnonymousAuthenticationArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var url: Output<Any>? = null

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'Anonymous'.
     */
    @JvmName("ywalawllltkxgcfg")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("oybqxxuhqeotcyso")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'Anonymous'.
     */
    @JvmName("uxbekvbmguwgewih")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("enufxljgnvrqckuf")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): WebAnonymousAuthenticationArgs = WebAnonymousAuthenticationArgs(
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
