@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebBasicAuthenticationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A WebLinkedService that uses basic authentication to communicate with an HTTP endpoint.
 * @property authenticationType Type of authentication used to connect to the web table source.
 * Expected value is 'Basic'.
 * @property password The password for Basic authentication.
 * @property url The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
 * @property username User name for Basic authentication. Type: string (or Expression with resultType string).
 */
public data class WebBasicAuthenticationArgs(
    public val authenticationType: Output<String>,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val url: Output<Any>,
    public val username: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebBasicAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebBasicAuthenticationArgs =
        com.pulumi.azurenative.datafactory.inputs.WebBasicAuthenticationArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .url(url.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebBasicAuthenticationArgs].
 */
@PulumiTagMarker
public class WebBasicAuthenticationArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var url: Output<Any>? = null

    private var username: Output<Any>? = null

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'Basic'.
     */
    @JvmName("oterwqblqgfsmhwf")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The password for Basic authentication.
     */
    @JvmName("qcmndggqxlpxvqlf")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("boeomrgttajyifue")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value User name for Basic authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("enaacstrglkvkgsh")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'Basic'.
     */
    @JvmName("nfijvtdtrlfghrqd")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The password for Basic authentication.
     */
    @JvmName("acclbgtypscetvtu")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password for Basic authentication.
     */
    @JvmName("jadpyonelfoiqhph")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password for Basic authentication.
     */
    @JvmName("crlqmfehhhiointh")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("gfbeluobawpqgnou")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value User name for Basic authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("ofbqvytdtujmofdd")
    public suspend fun username(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): WebBasicAuthenticationArgs = WebBasicAuthenticationArgs(
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        password = password ?: throw PulumiNullFieldException("password"),
        url = url ?: throw PulumiNullFieldException("url"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
