@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Web linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'Web'.
 * @property typeProperties Web linked service properties.
 */
public data class WebLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val typeProperties: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.WebLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .typeProperties(typeProperties.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebLinkedServiceArgs].
 */
@PulumiTagMarker
public class WebLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var typeProperties: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xyasghygcurvpexx")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("dxtgvluihcxdjgep")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("llvptsvhgnipwvab")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ilcnxyksssefefbu")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("beuxkorwgnsfkrhv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("gwlxfssxxvavhihu")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Web'.
     */
    @JvmName("bhqccevyjlnideto")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Web linked service properties.
     */
    @JvmName("qjulxvggfsbrbahy")
    public suspend fun typeProperties(`value`: Output<Any>) {
        this.typeProperties = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("bebkhweybevfkysn")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("wwsxwhemoifrdlsl")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("uqlbigkvwgaieuef")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ghjfecwxxyeldmiy")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("djnyimbdcyvlcnah")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("cxeltgixdekehwto")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("yqjuloaospjmbxyk")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("vwepflkgvjhyoqkq")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Web'.
     */
    @JvmName("ucqvtkhmspnyygro")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Web linked service properties.
     */
    @JvmName("ymyhmwkidhlinwrn")
    public suspend fun typeProperties(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeProperties = mapped
    }

    internal fun build(): WebLinkedServiceArgs = WebLinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
        typeProperties = typeProperties ?: throw PulumiNullFieldException("typeProperties"),
    )
}
