@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.XmlReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Xml read settings.
 * @property compressionProperties Compression settings.
 * @property detectDataType Indicates whether type detection is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
 * @property namespacePrefixes Namespace uri to prefix mappings to override the prefixes in column names when namespace is enabled, if no prefix is defined for a namespace uri, the prefix of xml element/attribute name in the xml data file will be used. Example: "{"http://www.example.com/xml":"prefix"}" Type: object (or Expression with resultType object).
 * @property namespaces Indicates whether namespace is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'XmlReadSettings'.
 * @property validationMode Indicates what validation method is used when reading the xml files. Allowed values: 'none', 'xsd', or 'dtd'. Type: string (or Expression with resultType string).
 */
public data class XmlReadSettingsArgs(
    public val compressionProperties: Output<Any>? = null,
    public val detectDataType: Output<Any>? = null,
    public val namespacePrefixes: Output<Any>? = null,
    public val namespaces: Output<Any>? = null,
    public val type: Output<String>,
    public val validationMode: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.XmlReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.XmlReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.XmlReadSettingsArgs.builder()
            .compressionProperties(compressionProperties?.applyValue({ args0 -> args0 }))
            .detectDataType(detectDataType?.applyValue({ args0 -> args0 }))
            .namespacePrefixes(namespacePrefixes?.applyValue({ args0 -> args0 }))
            .namespaces(namespaces?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .validationMode(validationMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [XmlReadSettingsArgs].
 */
@PulumiTagMarker
public class XmlReadSettingsArgsBuilder internal constructor() {
    private var compressionProperties: Output<Any>? = null

    private var detectDataType: Output<Any>? = null

    private var namespacePrefixes: Output<Any>? = null

    private var namespaces: Output<Any>? = null

    private var type: Output<String>? = null

    private var validationMode: Output<Any>? = null

    /**
     * @param value Compression settings.
     */
    @JvmName("koioetedbrdxqdbi")
    public suspend fun compressionProperties(`value`: Output<Any>) {
        this.compressionProperties = value
    }

    /**
     * @param value Indicates whether type detection is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wasabdablmhvxooa")
    public suspend fun detectDataType(`value`: Output<Any>) {
        this.detectDataType = value
    }

    /**
     * @param value Namespace uri to prefix mappings to override the prefixes in column names when namespace is enabled, if no prefix is defined for a namespace uri, the prefix of xml element/attribute name in the xml data file will be used. Example: "{"http://www.example.com/xml":"prefix"}" Type: object (or Expression with resultType object).
     */
    @JvmName("obxkqrxhxsbicflt")
    public suspend fun namespacePrefixes(`value`: Output<Any>) {
        this.namespacePrefixes = value
    }

    /**
     * @param value Indicates whether namespace is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xwdnougmcsovghsf")
    public suspend fun namespaces(`value`: Output<Any>) {
        this.namespaces = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'XmlReadSettings'.
     */
    @JvmName("wiremcrvkabglopg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Indicates what validation method is used when reading the xml files. Allowed values: 'none', 'xsd', or 'dtd'. Type: string (or Expression with resultType string).
     */
    @JvmName("gmncqgfnwmmqhbwe")
    public suspend fun validationMode(`value`: Output<Any>) {
        this.validationMode = value
    }

    /**
     * @param value Compression settings.
     */
    @JvmName("tvstbqlclgoxwjkn")
    public suspend fun compressionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionProperties = mapped
    }

    /**
     * @param value Indicates whether type detection is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ggiaujfbdfljksax")
    public suspend fun detectDataType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectDataType = mapped
    }

    /**
     * @param value Namespace uri to prefix mappings to override the prefixes in column names when namespace is enabled, if no prefix is defined for a namespace uri, the prefix of xml element/attribute name in the xml data file will be used. Example: "{"http://www.example.com/xml":"prefix"}" Type: object (or Expression with resultType object).
     */
    @JvmName("pfpsbjcamberplpt")
    public suspend fun namespacePrefixes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespacePrefixes = mapped
    }

    /**
     * @param value Indicates whether namespace is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ylsmxkpnlaafcsnq")
    public suspend fun namespaces(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaces = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'XmlReadSettings'.
     */
    @JvmName("rnmbppujtmgiysxu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Indicates what validation method is used when reading the xml files. Allowed values: 'none', 'xsd', or 'dtd'. Type: string (or Expression with resultType string).
     */
    @JvmName("lnnujyvdyrmdecsx")
    public suspend fun validationMode(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationMode = mapped
    }

    internal fun build(): XmlReadSettingsArgs = XmlReadSettingsArgs(
        compressionProperties = compressionProperties,
        detectDataType = detectDataType,
        namespacePrefixes = namespacePrefixes,
        namespaces = namespaces,
        type = type ?: throw PulumiNullFieldException("type"),
        validationMode = validationMode,
    )
}
