@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Activity dependency information.
 * @property activity Activity name.
 * @property dependencyConditions Match-Condition for the dependency.
 */
public data class ActivityDependencyResponse(
    public val activity: String,
    public val dependencyConditions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ActivityDependencyResponse): ActivityDependencyResponse = ActivityDependencyResponse(
            activity = javaType.activity(),
            dependencyConditions = javaType.dependencyConditions().map({ args0 -> args0 }),
        )
    }
}
