@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Amazon RDS for SQL Server linked service.
 * @property alwaysEncryptedSettings Sql always encrypted properties.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property applicationIntent The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
 * @property authenticationType The type used for authentication. Type: string.
 * @property commandTimeout The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectRetryCount The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
 * @property connectRetryInterval The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
 * @property connectTimeout The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database The name of the database, used by recommended version. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encrypt Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property failoverPartner The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
 * @property hostNameInCertificate The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
 * @property integratedSecurity Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property loadBalanceTimeout The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property maxPoolSize The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property minPoolSize The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property multiSubnetFailover If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property multipleActiveResultSets When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property packetSize The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property parameters Parameters for linked service.
 * @property password The on-premises Windows authentication password.
 * @property pooling Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property server The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
 * @property trustServerCertificate Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property type Type of linked service.
 * Expected value is 'AmazonRdsForSqlServer'.
 * @property userName The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
 */
public data class AmazonRdsForSqlServerLinkedServiceResponse(
    public val alwaysEncryptedSettings: SqlAlwaysEncryptedPropertiesResponse? = null,
    public val annotations: List<Any>? = null,
    public val applicationIntent: Any? = null,
    public val authenticationType: String? = null,
    public val commandTimeout: Any? = null,
    public val connectRetryCount: Any? = null,
    public val connectRetryInterval: Any? = null,
    public val connectTimeout: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionString: Any? = null,
    public val database: Any? = null,
    public val description: String? = null,
    public val encrypt: Any? = null,
    public val encryptedCredential: String? = null,
    public val failoverPartner: Any? = null,
    public val hostNameInCertificate: Any? = null,
    public val integratedSecurity: Any? = null,
    public val loadBalanceTimeout: Any? = null,
    public val maxPoolSize: Any? = null,
    public val minPoolSize: Any? = null,
    public val multiSubnetFailover: Any? = null,
    public val multipleActiveResultSets: Any? = null,
    public val packetSize: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val pooling: Any? = null,
    public val server: Any? = null,
    public val trustServerCertificate: Any? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AmazonRdsForSqlServerLinkedServiceResponse): AmazonRdsForSqlServerLinkedServiceResponse = AmazonRdsForSqlServerLinkedServiceResponse(
            alwaysEncryptedSettings = javaType.alwaysEncryptedSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SqlAlwaysEncryptedPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            applicationIntent = javaType.applicationIntent().map({ args0 -> args0 }).orElse(null),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            commandTimeout = javaType.commandTimeout().map({ args0 -> args0 }).orElse(null),
            connectRetryCount = javaType.connectRetryCount().map({ args0 -> args0 }).orElse(null),
            connectRetryInterval = javaType.connectRetryInterval().map({ args0 -> args0 }).orElse(null),
            connectTimeout = javaType.connectTimeout().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            database = javaType.database().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encrypt = javaType.encrypt().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            failoverPartner = javaType.failoverPartner().map({ args0 -> args0 }).orElse(null),
            hostNameInCertificate = javaType.hostNameInCertificate().map({ args0 -> args0 }).orElse(null),
            integratedSecurity = javaType.integratedSecurity().map({ args0 -> args0 }).orElse(null),
            loadBalanceTimeout = javaType.loadBalanceTimeout().map({ args0 -> args0 }).orElse(null),
            maxPoolSize = javaType.maxPoolSize().map({ args0 -> args0 }).orElse(null),
            minPoolSize = javaType.minPoolSize().map({ args0 -> args0 }).orElse(null),
            multiSubnetFailover = javaType.multiSubnetFailover().map({ args0 -> args0 }).orElse(null),
            multipleActiveResultSets = javaType.multipleActiveResultSets().map({ args0 -> args0 }).orElse(null),
            packetSize = javaType.packetSize().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            pooling = javaType.pooling().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            trustServerCertificate = javaType.trustServerCertificate().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
