@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Avro write settings.
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property recordName Top level record name in write result, which is required in AVRO spec.
 * @property recordNamespace Record namespace in the write result.
 * @property type The write setting type.
 * Expected value is 'AvroWriteSettings'.
 */
public data class AvroWriteSettingsResponse(
    public val fileNamePrefix: Any? = null,
    public val maxRowsPerFile: Any? = null,
    public val recordName: String? = null,
    public val recordNamespace: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AvroWriteSettingsResponse): AvroWriteSettingsResponse = AvroWriteSettingsResponse(
            fileNamePrefix = javaType.fileNamePrefix().map({ args0 -> args0 }).orElse(null),
            maxRowsPerFile = javaType.maxRowsPerFile().map({ args0 -> args0 }).orElse(null),
            recordName = javaType.recordName().map({ args0 -> args0 }).orElse(null),
            recordNamespace = javaType.recordNamespace().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
