@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The express custom setup of installing Azure PowerShell.
 * @property type The type of custom setup.
 * Expected value is 'AzPowerShellSetup'.
 * @property version The required version of Azure PowerShell to install.
 */
public data class AzPowerShellSetupResponse(
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzPowerShellSetupResponse): AzPowerShellSetupResponse = AzPowerShellSetupResponse(
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
