@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Batch linked service.
 * @property accessKey The Azure Batch account access key.
 * @property accountName The Azure Batch account name. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property batchUri The Azure Batch URI. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property linkedServiceName The Azure Storage linked service reference.
 * @property parameters Parameters for linked service.
 * @property poolName The Azure Batch pool name. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureBatch'.
 */
public data class AzureBatchLinkedServiceResponse(
    public val accessKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val accountName: Any,
    public val annotations: List<Any>? = null,
    public val batchUri: Any,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val poolName: Any,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureBatchLinkedServiceResponse): AzureBatchLinkedServiceResponse = AzureBatchLinkedServiceResponse(
            accessKey = javaType.accessKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            accountName = javaType.accountName(),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            batchUri = javaType.batchUri(),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            poolName = javaType.poolName(),
            type = javaType.type(),
        )
    }
}
