@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The azure blob storage linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property accountKind Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The type used for authentication. Type: string.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property containerUri Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType string).
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property serviceEndpoint Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
 * @property servicePrincipalId The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Azure SQL Data Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureBlobStorage'.
 */
public data class AzureBlobStorageLinkedServiceResponse(
    public val accountKey: AzureKeyVaultSecretReferenceResponse? = null,
    public val accountKind: Any? = null,
    public val annotations: List<Any>? = null,
    public val authenticationType: String? = null,
    public val azureCloudType: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionString: Any? = null,
    public val containerUri: Any? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val sasToken: AzureKeyVaultSecretReferenceResponse? = null,
    public val sasUri: Any? = null,
    public val serviceEndpoint: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val tenant: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureBlobStorageLinkedServiceResponse): AzureBlobStorageLinkedServiceResponse = AzureBlobStorageLinkedServiceResponse(
            accountKey = javaType.accountKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accountKind = javaType.accountKind().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            azureCloudType = javaType.azureCloudType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            containerUri = javaType.containerUri().map({ args0 -> args0 }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            sasToken = javaType.sasToken().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasUri = javaType.sasUri().map({ args0 -> args0 }).orElse(null),
            serviceEndpoint = javaType.serviceEndpoint().map({ args0 -> args0 }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
