@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The location of azure blob dataset.
 * @property container Specify the container of azure blob. Type: string (or Expression with resultType string).
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AzureBlobStorageLocation'.
 */
public data class AzureBlobStorageLocationResponse(
    public val container: Any? = null,
    public val fileName: Any? = null,
    public val folderPath: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureBlobStorageLocationResponse): AzureBlobStorageLocationResponse = AzureBlobStorageLocationResponse(
            container = javaType.container().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
