@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Data Explorer (Kusto) linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property database Database name for connection. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property endpoint The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://<clusterName>.<regionName>.kusto.windows.net. Type: string (or Expression with resultType string)
 * @property parameters Parameters for linked service.
 * @property servicePrincipalId The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Kusto.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureDataExplorer'.
 */
public data class AzureDataExplorerLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val database: Any,
    public val description: String? = null,
    public val endpoint: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val tenant: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDataExplorerLinkedServiceResponse): AzureDataExplorerLinkedServiceResponse = AzureDataExplorerLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            database = javaType.database(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
