@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Azure Databricks Delta Lake import command settings.
 * @property dateFormat Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property timestampFormat Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property type The import setting type.
 * Expected value is 'AzureDatabricksDeltaLakeImportCommand'.
 */
public data class AzureDatabricksDeltaLakeImportCommandResponse(
    public val dateFormat: Any? = null,
    public val timestampFormat: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDatabricksDeltaLakeImportCommandResponse): AzureDatabricksDeltaLakeImportCommandResponse =
            AzureDatabricksDeltaLakeImportCommandResponse(
                dateFormat = javaType.dateFormat().map({ args0 -> args0 }).orElse(null),
                timestampFormat = javaType.timestampFormat().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
