@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure ML Execute Pipeline activity.
 * @property continueOnStepFailure Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the continueOnStepFailure property of the published pipeline execution request. Type: boolean (or Expression with resultType boolean).
 * @property dataPathAssignments Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments property of the published pipeline execution request. Type: object (or Expression with resultType object).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property experimentName Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the published pipeline execution request. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property mlParentRunId The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published pipeline execution request. Type: string (or Expression with resultType string).
 * @property mlPipelineEndpointId ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
 * @property mlPipelineId ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
 * @property mlPipelineParameters Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression with resultType object).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'AzureMLExecutePipeline'.
 * @property userProperties Activity user properties.
 * @property version Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
 */
public data class AzureMLExecutePipelineActivityResponse(
    public val continueOnStepFailure: Any? = null,
    public val dataPathAssignments: Any? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val experimentName: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val mlParentRunId: Any? = null,
    public val mlPipelineEndpointId: Any? = null,
    public val mlPipelineId: Any? = null,
    public val mlPipelineParameters: Any? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
    public val version: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureMLExecutePipelineActivityResponse): AzureMLExecutePipelineActivityResponse = AzureMLExecutePipelineActivityResponse(
            continueOnStepFailure = javaType.continueOnStepFailure().map({ args0 -> args0 }).orElse(null),
            dataPathAssignments = javaType.dataPathAssignments().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mlParentRunId = javaType.mlParentRunId().map({ args0 -> args0 }).orElse(null),
            mlPipelineEndpointId = javaType.mlPipelineEndpointId().map({ args0 -> args0 }).orElse(null),
            mlPipelineId = javaType.mlPipelineId().map({ args0 -> args0 }).orElse(null),
            mlPipelineParameters = javaType.mlPipelineParameters().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
